#
# unix/Common.mk.in  --
#
# Common macro definitions used by all include files.
#------------------------------------------------------------------------------
# Copyright 1995-1997 Karl Lehenbauer and Mark Diekhans.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  Karl Lehenbauer and
# Mark Diekhans make no representations about the suitability of this
# software for any purpose.  It is provided "as is" without express or
# implied warranty.
#------------------------------------------------------------------------------
# $Id: Common.mk.in,v 8.7.2.1 1998/08/09 06:46:36 markd Exp $
#------------------------------------------------------------------------------
#

SHELL = /bin/sh

#------------------------------------------------------------------------------
# Tcl and Tk versions
#
TCL_VERSION      = 8.0
TK_VERSION       = 8.0

#------------------------------------------------------------------------------
# TclX version information extracted from tclExtend.h.
#
TCLX_VERSION       = 8.0.3
TCLX_FULL_VERSION  = 8.0.3

TKX_VERSION        = 8.0.3
TKX_FULL_VERSION   = 8.0.3

#------------------------------------------------------------------------------
# Autoconfig defines that can be overridden in Config.mk.
#
CC           = gcc -pipe -Wall
CFLAGS       = -g -O2
SYSCFLAGS    = 
RANLIB       = ranlib
LN_S         = ln -s
srcbasedir   = /dsk/data/de/src/tclX8.0.3
bldbasedir   = /dsk/data/de/src/tclX8.0.3
prefix       = /opt/tcl803
exec_prefix  = /opt/tcl803

#------------------------------------------------------------------------------
# TclX configuration information determined by configure.
#
BUILD_SHARED = YES
TKX_BUILD    = YES
TCLX_DEFS    =  -DHAVE_TCL_STANDALONE=1 -DHAVE_TK_STANDALONE=1 -DSTDC_HEADERS=1 -DRETSIGTYPE=void -DNO_INET_ATON=1 
TCLX_LIBS    = 

#------------------------------------------------------------------------------
# Library names.
#
TCL_STLIB_NAME  = libtcl8.0.a
TK_STLIB_NAME   = libtk8.0.a

TCLX_SHLIB_NAME = libtclx8.0.3.so
TCLX_STLIB_NAME = libtclx8.0.3.a
TCLX_LIB_NAME   = libtclx8.0.3.so

TKX_SHLIB_NAME       = libtkx8.0.3.so
TKX_STLIB_NAME       = libtkx8.0.3.a
TKX_LIB_NAME         = libtkx8.0.3.so

#------------------------------------------------------------------------------
# Compiler flag to use when generating shared object files.  Unixware cc will
# only output the name of the .c file, so we hack it.

CC_SHOBJ_FLAG = -o $@

#------------------------------------------------------------------------------
# Linker arguments to pick up TclX libraries.
#
TCLX_BUILD_LIB_SPEC  = -L/dsk/data/de/src/tclX8.0.3/tcl/unix -ltclx8.0.3
TKX_BUILD_LIB_SPEC   = -L/dsk/data/de/src/tclX8.0.3/tk/unix -ltkx8.0.3
TCLX_LD_SEARCH_FLAGS = -R /opt/tcl803/lib
TCLX_CC_SEARCH_FLAGS = -Wl,-R,/opt/tcl803/lib
TKX_LD_SEARCH_FLAGS  = -R /opt/tcl803/lib:/opt/X11R6.3/lib
TKX_CC_SEARCH_FLAGS  = -Wl,-R,/opt/tcl803/lib:/opt/X11R6.3/lib

#------------------------------------------------------------------------------
# Configuration information from tclConfig.sh and tkConfig.sh.
#
TCL_DEFS             =  -DHAVE_GETCWD=1 -DHAVE_OPENDIR=1 -DHAVE_STRSTR=1 -DHAVE_STRTOL=1 -DHAVE_TMPNAM=1 -DHAVE_WAITPID=1 -DHAVE_UNISTD_H=1 -DUSE_TERMIOS=1 -DHAVE_SYS_TIME_H=1 -DTIME_WITH_SYS_TIME=1 -DHAVE_TZNAME=1 -DHAVE_TIMEZONE_VAR=1 -DHAVE_ST_BLKSIZE=1 -DSTDC_HEADERS=1 -DNO_UNION_WAIT=1 -DNEED_MATHERR=1 -DRETSIGTYPE=void -DHAVE_SIGNED_CHAR=1 -DHAVE_SYS_IOCTL_H=1 -DHAVE_SYS_FILIO_H=1 
TCL_LIBS             = -ldl  -lsocket -lnsl -lm
TCL_EXEC_PREFIX      = /opt/tcl803
TCL_SHLIB_CFLAGS     = -fpic
TCL_LD_FLAGS         = 
TCL_DL_LIBS          = -ldl
TCL_SHLIB_LD         = /usr/ccs/bin/ld -G -z text
TCL_SHLIB_LD_LIBS    = ${LIBS}
TCL_BUILD_LIB_SPEC   = -L/dsk/data/de/src/tcl8.0.3/unix -ltcl8.0${TCL_DBGX}
TCL_LIB_SPEC         = -L/opt/tcl803/lib -ltcl8.0${TCL_DBGX}
TCL_LD_SEARCH_FLAGS  = -Wl,-R,${LIB_RUNTIME_DIR}

TK_DEFS              =  -DHAVE_UNISTD_H=1 -DHAVE_LIMITS_H=1 -DSTDC_HEADERS=1 -DHAVE_SYS_TIME_H=1 -DTIME_WITH_SYS_TIME=1 
TK_LIBS              = -L/opt/X11R6.3/lib -lX11 -ldl  -lsocket -lnsl -lm
TK_EXEC_PREFIX       = /opt/tcl803
TK_XINCLUDES         = -I/opt/X11R6.3/include
TK_XLIBSW            = -L/opt/X11R6.3/lib -lX11
TK_BUILD_LIB_SPEC    = -L/dsk/data/de/src/tk8.0.3/unix -ltk8.0${TK_DBGX}
TK_LIB_SPEC          = -L/opt/tcl803/lib -ltk8.0${TK_DBGX}
TK_LD_SEARCH_FLAGS   = -Wl,-R,${LIB_RUNTIME_DIR}

#------------------------------------------------------------------------------
# Location of directories.
#
TCL_GENERIC_DIR    = ${TCL_SRC}/generic
TCL_UNIX_DIR       = ${TCL_SRC}/unix
TCL_LIBRARY_DIR    = ${TCL_SRC}/library
TK_GENERIC_DIR     = ${TK_SRC}/generic
TK_UNIX_DIR        = ${TK_SRC}/unix

TCLX_GENERIC_DIR   = ${srcbasedir}/tcl/generic
TCLX_UNIX_SRC_DIR  = ${srcbasedir}/tcl/unix
TCLX_UNIX_BLD_DIR  = ${bldbasedir}/tcl/unix
TKX_GENERIC_DIR    = ${srcbasedir}/tk/generic
TKX_UNIX_SRC_DIR   = ${srcbasedir}/tk/unix
TKX_UNIX_BLD_DIR   = ${bldbasedir}/tk/unix
COMPAT_DIR         = ${srcbasedir}/tcl/compat

#------------------------------------------------------------------------------
# Programs run during the build.
#
TCLX_TMP_RUNTIME   = ${bldbasedir}/tcl/unix
TKX_TMP_RUNTIME    = ${bldbasedir}/tk/unix

RUNTCL             = ${bldbasedir}/unix/runtcl
RUNWISHX           = ${bldbasedir}/unix/runwishx
GENTNDX            = ${RUNTCL} ${srcbasedir}/unix/tools/genindex.tcl
BLDMANHELP         = ${RUNTCL} ${bldbasedir}/unix/tools/bldmanhelp
CONVERTLIB         = ${RUNTCL} ${srcbasedir}/unix/tools/libconvert.tcl
INSTCOPY           = ${RUNTCL} ${bldbasedir}/unix/tools/instcopy
CPMANPAGES         = ${RUNTCL} ${bldbasedir}/unix/tools/cpmanpages

  
#------------------------------------------------------------------------------
# For conversion of a tcl-script into C-strings.  Used in standalone binaries.
# Requires Tcl PlusPatch.
#
.SUFFIXES: .tcl $(SUFFIXES)

.tcl.c:
	${TCL2C} -o $@ -a -n $@ $<
