#
# fonts_list.tcl
#

widget fonts_list {
    object_include tkinspect_list
    param title "Fonts"
    method get_item_name {} { return font }
    method update {target} {
	$self clear
	foreach font [lsort [send $target font names]] {
	    $self append $font
	}
    }
    method retrieve {target font} {
        set cmd [list font configure $font]
        set retcode [catch [list send $target $cmd] msg]
        if {$retcode != 0} {
            set result "Error: $msg\n"
        } elseif {$msg != ""} {
	    set result "font configure $font "
	    foreach {opt val} $msg {append result " \\\n\t" [list $opt $val]}
        } else {
            set result "Error: empty \[font configure $font]?\n"
        }
	return $result
    }
    method send_filter {value} {
	return $value
    }
}
