
proc load_file {dirlist file {recurse 1}} {
    foreach dir $dirlist {
	if {[file exists [set path [file join $dir $file]]]} {
	    set hdl [open $path r]
	    set text [read -nonewline $hdl]
	    close $hdl
	    return $text
	}
	if {$recurse} {
	    foreach f [glob -nocomplain $dir/*] {
		if {[file isdirectory $f]} {
		    if {[catch {load_file $f $file 1} result]} {
			if {[string compare $result "File Not Found"]} {
			    error $result $::errorInfo
			}
		    } else {
			# Success!
			return $result
		    }
		}
	    }
	}
    }
    # If we got here, we didn't find the file.
    error "File Not Found"
}
