#!/bin/sh
# the next line restarts using wish \
	exec wish "$0" ${1+"$@"}

## widgets.tcl
##
## Modified from original demo
##
## jeff.hobbs@acm.org

source [file join [file dirname [info script]] load.tcl]

set i 1
set j 50
set k 75

proc random {{rng 2}} {
    return [expr {int(rand()*$rng)}]
}

# Cheap rescheduler
#
# every <time> cmd;	# cmd is a one arg (cmd as list)
#	schedules $cmd to be run every <time> 1000ths of a sec
#	IOW, [every 1000 "puts hello"] prints hello every sec
# every cancel cmd
#	cancels a cmd if it was specified
# every info ?pattern?
#	returns info about commands in pairs of "time cmd time cmd ..."
#
proc every {time {cmd {}}} {
    global EVERY
    if {[regexp {^[0-9]+$} $time]} {
	# A time was given, so schedule a command to run every $time msecs
	if {[string compare {} $cmd]} {
	    set EVERY(TIME,$cmd) $time
	    set EVERY(CMD,$cmd) [after $time [list every eval $cmd]]
	}
	return
    }
    switch $time {
	eval {
	    if {[info exists EVERY(TIME,$cmd)]} {
		uplevel \#0 $cmd
		set EVERY(CMD,$cmd) [after $EVERY(TIME,$cmd) \
			[list every eval $cmd]]
	    }
	}
	cancel {
	    if {[string match "all" $cmd]} {
		foreach i [array names EVERY CMD,*] {
		    after cancel $EVERY($i)
		    unset EVERY($i) EVERY(TIME,[string range $i 4 end])
		}
	    } elseif {[info exists EVERY(CMD,$cmd)]} {
		after cancel $EVERY(CMD,$cmd)
		unset EVERY(CMD,$cmd) EVERY(TIME,$cmd)
	    }
	}
	info {
	    set result {}
	    foreach i [array names EVERY TIME,$cmd*] {
		set cmd [string range $i 5 end]
		lappend result $EVERY($i) $cmd
	    }
	    return $result
	}
    }
    return
}

proc updateBar {w} {
    global j
    if {[random]} {
	incr j
    } else {
	incr j -1
    }
    $w set $j
    if {$j < 25} {
	if {$j == 0} {set j 100}
	$w configure -barcolor green
    } elseif {($j >= 25) && ($j < 50)} {
	$w configure -barcolor blue
    } elseif {($j >= 50) && ($j < 75)} {
	$w configure -barcolor purple
    } elseif {$j > 75} {
	$w configure -barcolor red
	if {$j == 100} {set j 0}
    }
}

puts "Show off all vu widgets"

dial .dial -resolution 0.001 -from -0.1 -to 0.1 -showvalue 1 \
	-minortickinterval 0.01 -tickinterval 0.1 -radius 50 \
	-label "Dial" -beginangle -20 -endangle 260 \
	-dialcolor red3 -active red2 -variable speed

bargraph .bar -from 0 -to 100 -relief raised -border 2 -label "Bar Chart"

button .gobar -text "Start"	-command {every 200 "updateBar .bar"}
button .nobar -text "Stop"	-command {every cancel "updateBar .bar"}
button .exit -text "Exit" -command exit

grid x .gobar -sticky ew -padx 4 -pady 4
grid .dial .bar -sticky news
grid x .nobar -sticky ew -padx 4 -pady 4
grid .exit - - -sticky ew -padx 16 -pady 2
grid columnconfig . 2 -weight 1
grid rowconfig . 1 -weight 1
