#ifndef PFIT_H
#define PFIT_H

#define ALGO_UNIFORM 1
#define ALGO_POWELL 2

struct splineinfo {
    int ns;			/* number of spline-fit positions */
    int nl;			/* allocated size of x, y, y2 */
    float *x;			/* desired label positions, ordered */
    float *y;			/* actual label positions, ordered */
    float *y2;			/* 2nd derivs of y=f(x) */
    float lower;		/* input: lower end of bar */
    float upper;		/* input: upper end of bar */
    unsigned int use_upper : 1;	/* !0 means upper tick was supplied by caller;
    				 * 0 means supplied by us for computation.
				 */
    unsigned int use_lower : 1;	/* !0 means upper tick was supplied by caller;
    				 * 0 means supplied by us for computation.
				 */
};

void free_sp(struct splineinfo *sp);
void init_labelloc(struct splineinfo *sp, int algorithm,
                        int lo, int hi, int cheight, int nlab, float *lab);
void clear_labelloc(struct splineinfo *sp);
float    *do_labelloc(struct splineinfo *sp, int *niter, float *fret);

#endif
