/* tkPracInit.c - a widget extension for Tk */

#include "pkg.h"

/* Function to call on loading the module */

#ifdef BUILD_vu
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#endif

#ifdef MAC_TCL
#pragma export on
#endif
EXTERN int
Vu_Init(interp)
    Tcl_Interp *interp;
{
    Tk_Window tkwin;

#include "pkgInitScript.h"

    if (
#ifdef USE_TCL_STUBS
	Tcl_InitStubs(interp, "8.0", 0)
#else
	Tcl_PkgRequire(interp, "Tcl", "8.0", 0)
#endif
	== NULL) {
	return TCL_ERROR;
    }
    if (
#ifdef USE_TK_STUBS
	Tk_InitStubs(interp, "8.0", 0)
#else
#    if (TK_MAJOR_VERSION == 8) && (TK_MINOR_VERSION == 0)
	/* We require 8.0 exact because of the Unicode in 8.1+ */
	Tcl_PkgRequire(interp, "Tk", "8.0", 1)
#    else
	Tcl_PkgRequire(interp, "Tk", "8.0", 0)
#    endif
#endif
	== NULL) {
	return TCL_ERROR;
    }
    if (Tcl_PkgProvide(interp, PACKAGE, VU_VERSION) != TCL_OK) {
	return TCL_ERROR;
    }

    tkwin = Tk_MainWindow(interp);

    Tcl_CreateObjCommand(interp, "dial", Tk_DialObjCmd,
	    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateObjCommand(interp, "pie", Tk_PieObjCmd,
	    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateObjCommand(interp, "spinbox", Tk_SpinboxObjCmd,
	    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateObjCommand(interp, "bargraph", Tk_BargraphCmd,
	    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

#if 1
    Tcl_CreateCommand(interp, "stripchart", Tk_StripchartCmd,
                    (ClientData) tkwin, (Tcl_CmdDeleteProc *) NULL);
#endif


#if 0
    Tcl_CreateObjCommand(interp, "combo", Tk_ComboObjCmd,
	    (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
#endif

    return Tcl_Eval(interp, initScript);
}

extern int
Vu_SafeInit(interp)
    Tcl_Interp *interp;
{
    return Vu_Init(interp);
}
#ifdef MAC_TCL
#pragma export reset
#endif

#if defined(WIN32) || defined(__WIN32__)
/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This wrapper function is used by Windows to invoke the
 *	initialization code for the DLL.  If we are compiling
 *	with Visual C++, this routine will be renamed to DllMain.
 *	routine.
 *
 * Results:
 *	Returns TRUE;
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

BOOL APIENTRY
DllEntryPoint(hInst, reason, reserved)
    HINSTANCE hInst;		/* Library instance handle. */
    DWORD reason;		/* Reason this function is being called. */
    LPVOID reserved;		/* Not used. */
{
    return TRUE;
}
#endif
