
static float bessj0(float x);

static float brent(float ax, float bx, float cx,
	float (*f)(float), float tol, float *xmin);

static float f1dim(float x);

static void linmin(float p[], float xi[], int n, float *fret,
	float (*func)(float []));

static void mnbrak(float *ax, float *bx, float *cx, float *fa, float *fb,
	float *fc, float (*func)(float));

/* ******************************************************************** */
/* ******************************************************************** */
	/* ****  COPYRIGHT: Everything below here is: **** */
	/* (C) Copr. 1986-92 Numerical Recipes Software 'N;,5%. */
/* ******************************************************************** */
/* ******************************************************************** */

#ifdef MIN
#undef MIN
#endif
#define MIN(a,b) (((a) < (b)) ? (a) : (b))

static float maxarg1,maxarg2;
#define FMAX(a,b) (maxarg1=(a),maxarg2=(b),(maxarg1) > (maxarg2) ?\
        (maxarg1) : (maxarg2))

#define SIGN(a,b) ((b) >= 0.0 ? fabs(a) : -fabs(a))

static float sqrarg;
#define SQR(a) ((sqrarg=(a)) == 0.0 ? 0.0 : sqrarg*sqrarg)



static void
powell(float p[], float **xi, int n, float ftol, int *iter, float *fret,
	float (*func)(float []))
{
    int i,ibig,j;
    float del,fp,fptt,t,*pt,*ptt,*xit;

    pt=vector(n);
    ptt=vector(n);
    xit=vector(n);
    *fret=1.234;
    *fret=(*func)(p);
    for (j=1;j<=n;j++) pt[j]=p[j];
    for (*iter=1;;++(*iter)) {
	fp=(*fret);
	ibig=0;
	del=0.0;
	for (i=1;i<=n;i++) {
	    for (j=1;j<=n;j++) xit[j]=xi[j][i];
	    fptt=(*fret);
	    linmin(p,xit,n,fret,func);
	    if (fabs(fptt-(*fret)) > del) {
		del=fabs(fptt-(*fret));
		ibig=i;
	    }
	}
	if (2.0*fabs(fp-(*fret)) <= ftol*(fabs(fp)+fabs(*fret))) {
	    free_vector(xit);
	    free_vector(ptt);
	    free_vector(pt);
	    return;
	}
	if (*iter == ITMAX) nrerror("powell exceeding maximum iterations.");
	for (j=1;j<=n;j++) {
	    ptt[j]=2.0*p[j]-pt[j];
	    xit[j]=p[j]-pt[j];
	    pt[j]=p[j];
	}
	fptt=(*func)(ptt);
	if (fptt < fp) {
	    t=2.0*(fp-2.0*(*fret)+fptt)*SQR(fp-(*fret)-del)-del*SQR(fp-fptt);
	    if (t < 0.0) {
		linmin(p,xit,n,fret,func);
		for (j=1;j<=n;j++) {
		    xi[j][ibig]=xi[j][n];
		    xi[j][n]=xit[j];
		}
	    }
	}
    }
}
#undef ITMAX

/* ******************************************************************** */
/* (C) Copr. 1986-92 Numerical Recipes Software 'N;,5%. */

static void
spline(float x[], float y[], int n, float yp1, float ypn, float y2[])
{
    int i,k;
    float p,qn,sig,un,*u;

    u=vector(n-1);
    if (yp1 > 0.99e30)
	    y2[1]=u[1]=0.0;
    else {
	    y2[1] = -0.5;
	    u[1]=(3.0/(x[2]-x[1]))*((y[2]-y[1])/(x[2]-x[1])-yp1);
    }
    for (i=2;i<=n-1;i++) {
	    sig=(x[i]-x[i-1])/(x[i+1]-x[i-1]);
	    p=sig*y2[i-1]+2.0;
	    y2[i]=(sig-1.0)/p;
	    u[i]=(y[i+1]-y[i])/(x[i+1]-x[i]) - (y[i]-y[i-1])/(x[i]-x[i-1]);
	    u[i]=(6.0*u[i]/(x[i+1]-x[i-1])-sig*u[i-1])/p;
    }
    if (ypn > 0.99e30)
	    qn=un=0.0;
    else {
	    qn=0.5;
	    un=(3.0/(x[n]-x[n-1]))*(ypn-(y[n]-y[n-1])/(x[n]-x[n-1]));
    }
    y2[n]=(un-qn*u[n-1])/(qn*y2[n-1]+1.0);
    for (k=n-1;k>=1;k--)
	    y2[k]=y2[k]*y2[k+1]+u[k];
    free_vector(u);
}

/* ******************************************************************** */
static void
splint_ab(float xa[], float ya[], float y2a[], float y2wgt,
	int n, float x, float *y, float *A, float *B,
	int crowd_uselower, int crowd_useupper, float *crowding)
{
    int klo,khi,k;
    float h,b,a, h2;

    klo=1;
    khi=n;
    while (khi-klo > 1) {
	    k=(khi+klo) >> 1;
	    if (xa[k] > x) khi=k;
	    else klo=k;
    }
    h = xa[khi]-xa[klo];
    if (h == 0.0) nrerror("Bad xa input to routine splint");
    a=(xa[khi]-x)/h;
    b=(x-xa[klo])/h;
    *y=a*ya[klo]+b*ya[khi] +
		y2wgt * ((a*a*a-a)*y2a[klo]+(b*b*b-b)*y2a[khi])*(h*h)/6.0;
    #if 0
	printf("x=%.2f | xa[%d]=%.2f  xa[%d]=%.2f | "
		"ya[%d]=%.2f  ya[%d]=%.2f | a=%.2f  h=%.2f\n", x,
			klo, xa[klo], khi, xa[khi],
			klo, ya[klo], khi, ya[khi], a, h);
    #endif
    *A = (xa[khi] - x);
    *B = (x - xa[klo]);

    /* *crowding is the distance between the closest tick and its nearest
     * neighbor.  crowd_useupper and crowd_uselower determine if the upper
     * and lower bounds are used in measuring crowding.
     */
    if (khi == n && !crowd_useupper) {
	/* not to consider distance from value to upper bound */
	/* (The following is wrong if n == 3 and crowd_uselower == 0) */
	*crowding = (klo > 1) ? (xa[klo] - xa[klo-1]) : h;
    } else if (klo == 1 && !crowd_uselower) {
	/* not to consider distance from value to lower bound */
	/* (The following is wrong if n == 3 and crowd_useupper == 0) */
	*crowding = (n > 2) ? (xa[khi+1] - xa[khi]) : h;
    } else if (a < b) {
	/* upper tick is closer */
	if (khi < n) {
	    h2 = xa[khi+1] - xa[khi];
	    *crowding = MIN(h2, h);
	} else {
	    *crowding = h;
	}
    } else {
	/* lower tick is closer */
	if (klo > 1) {
	    h2 = xa[klo] - xa[klo-1];
	    *crowding = MIN(h2, h);
	} else {
	    *crowding = h;
	}
    }
}
/* ******************************************************************** */

/* (C) Copr. 1986-92 Numerical Recipes Software 'N;,5%. */
static float
bessj0(float x)
{
    float ax,z;
    double xx,y,ans,ans1,ans2;

    if ((ax=fabs(x)) < 8.0) {
	    y=x*x;
	    ans1=57568490574.0+y*(-13362590354.0+y*(651619640.7
		    +y*(-11214424.18+y*(77392.33017+y*(-184.9052456)))));
	    ans2=57568490411.0+y*(1029532985.0+y*(9494680.718
		    +y*(59272.64853+y*(267.8532712+y*1.0))));
	    ans=ans1/ans2;
    } else {
	    z=8.0/ax;
	    y=z*z;
	    xx=ax-0.785398164;
	    ans1=1.0+y*(-0.1098628627e-2+y*(0.2734510407e-4
		    +y*(-0.2073370639e-5+y*0.2093887211e-6)));
	    ans2 = -0.1562499995e-1+y*(0.1430488765e-3
		    +y*(-0.6911147651e-5+y*(0.7621095161e-6
		    -y*0.934935152e-7)));
	    ans=sqrt(0.636619772/ax)*(cos(xx)*ans1-z*sin(xx)*ans2);
    }
    return ans;
}

#define ITMAX 100
#define CGOLD 0.3819660
#define ZEPS 1.0e-10
#define SHFT(a,b,c,d) (a)=(b);(b)=(c);(c)=(d);

static float
brent(float ax, float bx, float cx, float (*f)(float), float tol,
    float *xmin)
{
    int iter;
    float a,b,etemp,fu,fv,fw,fx,p,q,r,tol1,tol2,u,v,w,x,xm;
    float e=0.0;
    float d=0.0;

    a=(ax < cx ? ax : cx);
    b=(ax > cx ? ax : cx);
    x=w=v=bx;
    fw=fv=fx=(*f)(x);
    for (iter=1;iter<=ITMAX;iter++) {
	xm=0.5*(a+b);
	tol2=2.0*(tol1=tol*fabs(x)+ZEPS);
	if (fabs(x-xm) <= (tol2-0.5*(b-a))) {
	    *xmin=x;
	    return fx;
	}
	if (fabs(e) > tol1) {
	    r=(x-w)*(fx-fv);
	    q=(x-v)*(fx-fw);
	    p=(x-v)*q-(x-w)*r;
	    q=2.0*(q-r);
	    if (q > 0.0) p = -p;
	    q=fabs(q);
	    etemp=e;
	    e=d;
	    if (fabs(p) >= fabs(0.5*q*etemp) || p <= q*(a-x) || p >= q*(b-x)) {
		d=CGOLD*(e=(x >= xm ? a-x : b-x));
	    } else {
		d=p/q;
		u=x+d;
		if (u-a < tol2 || b-u < tol2)
		    d=SIGN(tol1,xm-x);
	    }
	} else {
		d=CGOLD*(e=(x >= xm ? a-x : b-x));
	}
	u=(fabs(d) >= tol1 ? x+d : x+SIGN(tol1,d));
	fu=(*f)(u);
	if (fu <= fx) {
	    if (u >= x) a=x; else b=x;
	    SHFT(v,w,x,u)
	    SHFT(fv,fw,fx,fu)
	} else {
	    if (u < x) a=u; else b=u;
	    if (fu <= fw || w == x) {
		v=w;
		w=u;
		fv=fw;
		fw=fu;
	    } else if (fu <= fv || v == x || v == w) {
		v=u;
		fv=fu;
	    }
	}
    }
    nrerror("Too many iterations in brent");
    *xmin=x;
    return fx;
}
#undef ITMAX
#undef CGOLD
#undef ZEPS
#undef SHFT

static int ncom;
static float *pcom,*xicom,(*nrfunc)(float []);

static float
f1dim(float x)
{
    int j;
    float f,*xt;

    xt=vector(ncom);
    for (j=1;j<=ncom;j++) xt[j]=pcom[j]+x*xicom[j];
    f=(*nrfunc)(xt);
    free_vector(xt);
    return f;
}
#define TOL 2.0e-4

static void
linmin(float p[], float xi[], int n, float *fret, float (*func)(float []))
{
    int j;
    float xx,xmin,fx,fb,fa,bx,ax;

    ncom=n;
    pcom=vector(n);
    xicom=vector(n);
    nrfunc=func;
    for (j=1;j<=n;j++) {
	    pcom[j]=p[j];
	    xicom[j]=xi[j];
    }
    ax=0.0;
    xx=1.0;
    mnbrak(&ax,&xx,&bx,&fa,&fx,&fb,f1dim);
    *fret=brent(ax,xx,bx,f1dim,TOL,&xmin);
    for (j=1;j<=n;j++) {
	    xi[j] *= xmin;
	    p[j] += xi[j];
    }
    free_vector(xicom);
    free_vector(pcom);
}
#undef TOL
#define GOLD 1.618034
#define GLIMIT 100.0
#define TINY 1.0e-20
#define SHFT(a,b,c,d) (a)=(b);(b)=(c);(c)=(d);

static void
mnbrak(float *ax, float *bx, float *cx, float *fa, float *fb, float *fc,
    float (*func)(float))
{
    float ulim,u,r,q,fu,dum;

    *fa=(*func)(*ax);
    *fb=(*func)(*bx);
    if (*fb > *fa) {
	    SHFT(dum,*ax,*bx,dum)
	    SHFT(dum,*fb,*fa,dum)
    }
    *cx=(*bx)+GOLD*(*bx-*ax);
    *fc=(*func)(*cx);
    while (*fb > *fc) {
	    r=(*bx-*ax)*(*fb-*fc);
	    q=(*bx-*cx)*(*fb-*fa);
	    u=(*bx)-((*bx-*cx)*q-(*bx-*ax)*r)/
		    (2.0*SIGN(FMAX(fabs(q-r),TINY),q-r));
	    ulim=(*bx)+GLIMIT*(*cx-*bx);
	    if ((*bx-u)*(u-*cx) > 0.0) {
		    fu=(*func)(u);
		    if (fu < *fc) {
			    *ax=(*bx);
			    *bx=u;
			    *fa=(*fb);
			    *fb=fu;
			    return;
		    } else if (fu > *fb) {
			    *cx=u;
			    *fc=fu;
			    return;
		    }
		    u=(*cx)+GOLD*(*cx-*bx);
		    fu=(*func)(u);
	    } else if ((*cx-u)*(u-ulim) > 0.0) {
		    fu=(*func)(u);
		    if (fu < *fc) {
			    SHFT(*bx,*cx,u,*cx+GOLD*(*cx-*bx))
			    SHFT(*fb,*fc,fu,(*func)(u))
		    }
	    } else if ((u-ulim)*(ulim-*cx) >= 0.0) {
		    u=ulim;
		    fu=(*func)(u);
	    } else {
		    u=(*cx)+GOLD*(*cx-*bx);
		    fu=(*func)(u);
	    }
	    SHFT(*ax,*bx,*cx,u)
	    SHFT(*fa,*fb,*fc,fu)
    }
}
#undef GOLD
#undef GLIMIT
#undef TINY
#undef SHFT


