if {[llength [info command bargraph]] == 0} {
    load ./vu[info sharedlibextension]
}

proc h {w h} {$w config -height $h}

bargraph .b -bd 30 -height 250 -relief flat -mode slider \
	-showwing true \
	-wingcolor green \
	-min -100 \
	-max 470000 \
	-tickinterval 0 \
	-ticklength 8

.b config -alabels {
	{ 24750   Open 1 }
	{ 124030  Decker 1 }
	{ 305100  7680:85 1 }
	{ 322100  6606:85 1 }
	{ 339250  6826:28 1 }
    }
.b config -blabels {
	{ 24750 1 1 }
	{ 124030 2 1 }
	{ 305100 3 1 }
	{ 322100 4 1 }
	{ 339250 5 1 }
    }

.b set 200000
pack .b -side left
############################################
bargraph .c -bd 30 -height 200 -relief flat -mode slider \
	-wingcolor yellow \
	-showwing true \
	-min 0 \
	-max 500000 \
	-tickinterval 0 \
	-ticklength 10

.c config -alabels {
	{ 74170		Open		1 }
	{ 166516	6.00_arcsec	1 }
	{ 169269	1.25_arcsec	1 }
	{ 172023	1.00_arcsec	1 }
	{ 174777	0.75_arcsec	1 }
	{ 177531	0.50_arcsec	1 }
    }

.c config -blabels {
	{ 74170		1	1 }
	{ 166516	2	1 }
	{ 169269	3	1 }
	{ 172023	4	1 }
	{ 174777	5	1 }
	{ 177531	6	1 }
    }

.c set 175000

pack .c -side left

############################################

bargraph .d -bd 30 -relief flat -mode slider \
	-wingcolor yellow \
	-showwing true \
	-tickinterval 0 \
	-ticklength 10

.d configure -label FOOBAR

.d set 50

.d config -showwing true

.d config -alabels "{10 foo} {50 bar} {51 boo} {90 baz}"
.d config -blabels "{48 boo} {50 bee} {52 fie}"

pack .d -side left


############################################
