#!/bin/sh
#\
exec /opt/tcl803/bin/tcl "$0"
# ----------------------------------------------------------------------
#  PURPOSE: Change review assignments for Tcl/Tk Conference
# ----------------------------------------------------------------------
source cgi.tcl
source common.tcl
package require Tclgdbm
source tclPaperslib.tcl

cgi_name "DoAssign"

# ----------------------------------------------------------------------
cgi_eval {
    cgi_input
    cgi_import action
    switch -- $action {

        Change {
            cgi_import name

            #
            # Get assignments from the database
            #
            set db [gdbm open data/tclPapers.dat rwc]
	    set all ""
            catch {set all [gdbm fetch $db "pc-$name-review"]}
            gdbm close $db

            set papers [TP_submission_all paper]
            set panels [TP_submission_all panel]
            set demos [TP_submission_all demonstration]
            set posters [TP_submission_all poster]

            TP_return_page {
                cgi_table border=0 cellpadding=2 cellspacing=0 bgcolor=antiquewhite {
                  cgi_form $CGIBASE/DoAssign.cgi method=post {
                    cgi_export name
                    cgi_table_row {
                      cgi_table_data colspan=2 {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 size=+1 [cgi_bold \
                            "&nbsp;$name"]]
                      }
                    }
                    foreach var {
                        papers panels demos posters
                    } heading {
                        Papers Panels Demonstrations Posters
                    } {
                      cgi_table_row {
                        cgi_table_data align=right {
                          cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                              color=#000000 "&nbsp;$heading"]
                        }
                        cgi_table_data {
                          cgi_put "<font face=Lucida,Helvetica,Arial color=#000000>"
                          cgi_select ${var}List size=5 multiple {
                            foreach token [set $var] {
                                set title [TP_submission $token title]
                                if {[lsearch $all $token] >= 0} {
                                    cgi_option $title selected
                                } else {
                                    cgi_option $title
                                }
                            }
                          }
                          cgi_put "</font>"
                        }
                      }
                    }
                    cgi_table_row {
                      cgi_table_data colspan=2 align=right {
                        cgi_put "<font face=Lucida,Helvetica,Arial color=#000000>"
                        cgi_submit_button action=Save
                        cgi_put "</font>&nbsp;"
                      }
                    }
                  }
                }
            }
        }

        Save {

		set log ""
            cgi_import name

            foreach var {papersList panelsList demosList postersList} {
                if {[catch {cgi_import $var}] != 0} {
                    set $var ""
                }
            }

            #
            # Erase all existing assignments
            #
            set db [gdbm open data/tclPapers.dat rw]
            set all [gdbm fetch $db "pc-$name-review"]
            gdbm close $db

            foreach token $all {
		append log "Deleted $token for $name\n"
                TP_reviewer_del $token $name
            }

            #
            # Make new assignments
            #
            set all ""
		append log "papersList is $papersList\n"
            foreach title [concat $papersList $panelsList $demosList $postersList] {
                set token [TP_submission_find $title]
		append log "  token for $title is $token\n"
                if {"" != $token} {
			append log "  add token $token to $name\n"
                    TP_reviewer_add $token $name
                    lappend all $token
                }
            }

#            TP_regenerate . admin

            TP_return_page {
                cgi_p [cgi_font size=+2 "Review assignments: [cgi_bold $name]"]
                cgi_bullet_list {
                    foreach token $all {
                        cgi_li [TP_submission $token title]
                    }
                }
#		cgi_p "<pre>$log</pre>"
            }
        }

        default {
            error "bad action \"$action\": should be Change or Save"
        }
    }
}
