#!/bin/sh
#\
exec /opt/tcl803/bin/tcl "$0"
# ----------------------------------------------------------------------
#  PURPOSE: Add/delete program committee members for Tcl/Tk Conference
# ----------------------------------------------------------------------
source cgi.tcl
source common.tcl
package require Tclgdbm
source tclPaperslib.tcl

cgi_name "DoDemos"

proc TP_return_page {script {heading ""}} {
    global BASE

    cgi_head {
        cgi_title "Status: Administration Request"
        cgi_put [eval $heading]
    }
    cgi_body bgcolor=#ffffff text=#000000 link=#ff0000 vlink=#303030 \
        background=$BASE/images/backgr2.gif {

        cgi_table border=0 cellpadding=0 cellspacing=0 {
          cgi_table_row {
            cgi_table_data {
              cgi_put [cgi_img $BASE/images/blank.gif border=0 width=140]
            }
            cgi_table_data valign=top {
              uplevel #0 $script
            }
          }
        }
    }
}

proc TP_return_error {mesg} {
    TP_return_page [format {
        cgi_table border=0 cellpadding=0 cellspacing=0 {
          cgi_table_row {
            cgi_table_data {
                cgi_put [cgi_img $BASE/images/error.gif border=0 alt=ERROR!]
            }
            cgi_table_data {
                cgi_put [cgi_strong %s]
                cgi_p
                cgi_put {Please back up and try again.}
            }
          }
        }
    } [list $mesg]]
}

# ----------------------------------------------------------------------
# USAGE: TP_regenerate <dir> <dir>...
#
# Regenerates HTML files in the specified directories.  This procedure
# looks for files named *.html.in in each directory, and then processes
# the files, evaluating any Tcl scripts within them.  The resulting
# files are saved as *.html files in the same directory.
# ----------------------------------------------------------------------
proc TP_regenerate {args} {
    foreach dir $args {
        foreach file [glob -nocomplain [file join $dir demos*.html.in]] {
            set fid [open $file "r"]
            set page [read $fid]
            close $fid

            set page [TP_process_page $page]

            set fid [open [file rootname $file] "w"]
            puts $fid $page
            close $fid
        }
    }
}

# ----------------------------------------------------------------------
# USAGE: TP_process_page <page>
#
# Takes an HTML <page> as input, and searches for regions marked
# with "@TCLSCRIPT@ ... @@".  The code within these markings is
# executed, and any resulting HTML is substituted in its place.
# The final page (with all substitutions) is returned as the
# result of this procedure.
# ----------------------------------------------------------------------
proc TP_process_page {page} {
    global tcl98html
    while {[regexp {(.*)@TCLSCRIPT@(.+)@@(.*)} $page dmy first script last]} {
        set tcl98html(buffer) ""
        $tcl98html(parser) eval $script
        set page [concat $first $tcl98html(buffer) $last]
    }
    return $page
}

# set tcl98html(parser) [interp create -safe]
# $tcl98html(parser) alias html TP_html
# $tcl98html(parser) alias demo_all TP_demo_all
# $tcl98html(parser) alias demo TP_demo

proc TP_html {str} {
    global tcl98html
    append tcl98html(buffer) $str "\n"
}

proc TP_demo_all {} {
	global DataFile
    set db [gdbm open $DataFile r]
	set all ""
    catch {set all [gdbm fetch $db "demos"]}
    gdbm close $db
    return $all
}

proc TP_demo {token attr} {
	global DataFile
    set db [gdbm open $DataFile r]
    set val [gdbm fetch $db $token-$attr]
    gdbm close $db
    return $val
}

# ----------------------------------------------------------------------
cgi_eval {
    cgi_input
    cgi_import action
    switch -- $action {
        Add {
            if {[catch {cgi_import name}] != 0 || "" == $name} {
                TP_return_error "Name missing for presenter"
                cgi_exit
            }

            if {[catch {cgi_import email}] != 0 || "" == $email ||
                ![string match "?*@?*" $email]} {
                TP_return_error "Invalid e-mail address \"$email\" for presenter"
                cgi_exit
            }
            set email [string trim $email]

            if {[catch {cgi_import title}] != 0 || "" == $title} {
                TP_return_error "Missing title for demo"
                cgi_exit
            }

            if {[catch {cgi_import affiliation}] != 0} {
                set affiliation ""
            }

            if {[catch {cgi_import overview}] != 0 || "" == $overview} {
                TP_return_error "Please include a few sentences describing your demo"
                cgi_exit
            }

            #
            # Add entry to database
            #
            set db [gdbm open $DataFile rwc]
	    set all ""
            catch {set all [gdbm fetch $db "demos"]}
            set found 0
            foreach token $all {
                set title2 [gdbm fetch $db "$token-title"]
                if {$title2 == $title} {
                    set found 1
                    break
                }
            }
            if {$found} {
                TP_return_error "Title \"$title\" is already used by another demo.  Select another title, or contact our <a href=\"mailto:tcl98@tclconsortium.org\">support staff</a> for assistance."
                cgi_exit
            }

            if {[llength $all] >= 10} {
                TP_return_page {
                    cgi_h2 "Sorry, all demo spots are currently full."
                    cgi_p "A few spots will be held open for on-site reservation, so we encourage all attendees with interesting demos to bring their work to the conference and register on site."
                }
                cgi_exit
            }

            set counter 0
            while {1} {
                set token "demo[incr counter]"
                if {[lsearch $all $token] < 0} {
                    break
                }
            }

            lappend all $token
            gdbm store $db "demos" $all
            gdbm store $db "$token-speaker" $name
            gdbm store $db "$token-affiliation" $affiliation
            gdbm store $db "$token-email" $email
            gdbm store $db "$token-title" $title
            gdbm store $db "$token-overview" $overview
            gdbm close $db

#            TP_regenerate .

            TP_return_page {
                cgi_p [cgi_font size=+2 "Registered: [cgi_bold $title]"]
		show_demo_list
            } 
        }

        Delete {
            if {[catch {cgi_import title}] != 0 || "" == $title} {
                TP_return_error "Name missing for title to delete"
                cgi_exit
            }

            #
            # Delete member from database
            #
            set db [gdbm open $DataFile rwc]
	    set all ""
            catch {set all [gdbm fetch $db "demos"]}

            set found 0
            foreach token $all {
                set title2 [gdbm fetch $db "$token-title"]
                if {$title2 == $title} {
                    set found 1
                    break
                }
            }

            if {!$found} {
                TP_return_error "Can't find title \"$title\""
                cgi_exit
            }

            set i [lsearch $all $token]
            if {$i >= 0} {
                set all [lreplace $all $i $i]
                gdbm store $db "demos" $all
                gdbm delete $db "$token-speaker"
                gdbm delete $db "$token-affiliation"
                gdbm delete $db "$token-email"
                gdbm delete $db "$token-title"
                gdbm delete $db "$token-overview"
            }
            gdbm close $db

#            TP_regenerate .

            TP_return_page {
                cgi_p [cgi_font size=+2 "Deleted: [cgi_bold $title]"]
		show_demo_list
            } 
        }

        Modify {
            if {[catch {cgi_import title}] != 0 || "" == $title} {
                TP_return_error "Name missing for title to delete"
                cgi_exit
            }

            #
            # Find member in database and modify
            #
            set db [gdbm open $DataFile rwc]
	    set all ""
            catch {set all [gdbm fetch $db "demos"]}

            set found 0
            foreach token $all {
                set title2 [gdbm fetch $db "$token-title"]
                if {$title2 == $title} {
                    set found 1
                    break
                }
            }

            if {!$found} {
                TP_return_error "Can't find title \"$title\""
                cgi_exit
            }

            gdbm store $db "demos" $all

            if {[catch {import name}] == 0 && "" != $name} {
                gdbm store $db "$token-speaker" $name
            }
            if {[catch {import email}] == 0 && "" != $email} {
                gdbm store $db "$token-email" $email
            }
            if {[catch {import affiliation}] == 0 && "" != $affiliation} {
                gdbm store $db "$token-affiliation" $affiliation
            }
            if {[catch {import overview}] == 0 && "" != $overview} {
                gdbm store $db "$token-overview" $overview
            }
            gdbm close $db

#            TP_regenerate .

            TP_return_page {
                cgi_p [cgi_font size=+2 "Modified: [cgi_bold $title]"]
		show_demo_list
            } 
        }

        default {
            error "bad action \"$action\": should be Add, Modify or Delete"
        }
    }
}
