#!/bin/sh
#\
exec /opt/tcl803/bin/tcl "$0"
# ----------------------------------------------------------------------
#  PURPOSE: Download all papers, panels, etc. for Tcl/Tk Conference
# ----------------------------------------------------------------------
source cgi.tcl
source common.tcl
package require Tclgdbm
source tclPaperslib.tcl

cgi_name "DoDownload"

proc max_mtime {dir} {
    set max [file mtime $dir]
    foreach file [glob -nocomplain [file join $dir *]] {
        if {[file isdirectory $file]} {
            set val [max_mtime $file]
        } else {
            set val [file mtime $file]
        }
        if {$val > $max} {
            set max $val
        }
    }
    return $max
}

# ----------------------------------------------------------------------
cgi_eval {

    #
    # Find the most recent modification time in "submissions".
    #
#    puts stderr "DoDownload find mtime of $HTMLDIR/submissions"

    set subdir $HTMLDIR/submissions
    set mtime [max_mtime $subdir]
    set disdir $HTMLDIR/distrib
    set dispat $HTMLURL/distrib
    set downloads [list $disdir/tcltkPapers.tar.gz $disdir/tcltkPapers.tar.Z]

    set regen 0

    foreach dfile $downloads {
#	puts stderr "CHECK FILE $dfile"
        if {![file exists $dfile] || \
		($mtime > [file mtime $dfile]) ||  \
		([file size $dfile] < 1000 )} {
            set regen 1
        }
    }

#    puts stderr "DoDownload regen is $regen"

    #
    # If need be, create the distribution files.
    #

    if {$regen} {

#	puts stderr "REGEN"

        set builddir tmp/tcltkPapers-[pid]
#	puts stderr "check for builddir $builddir"

        set err [catch {file mkdir $builddir/Papers} res]
	if {$err} {
#		puts stderr "ERROR making dir\n$res"
	}

        foreach paper [TP_submission_all] {

#	    puts stderr "Rebuild paper $paper"
            set authors [TP_submission $paper authors]
            set first [lindex [split $authors ","] 0]
            set name [string trim [string tolower [lindex $first end]]]

            if {[file exists $builddir/Papers/$name]} {
                set counter 1
                set root $name
                while {[file exists $builddir/Papers/$name]} {
                    set name "$root[incr counter]"
                }
            }

#	    puts stderr "COPY files from $subdir/$paper to $builddir/Papers/$name"
            file copy $subdir/$paper $builddir/Papers/$name

        }

        set dir [pwd]
        cd $builddir

#	puts stderr "CD to $builddir"

        set old [glob -nocomplain *.tar.*]
        if {[llength $old] > 0} {
            eval file delete -force $old
        }

#	puts stderr "Now Tar it up!"

        catch {exec tar cf tcltkPapers.tar ./Papers}
        catch {exec /opt/bin/gzip tcltkPapers.tar}

        catch {exec tar cf tcltkPapers.tar ./Papers}
        catch {exec compress tcltkPapers.tar}
        cd $dir

        catch {file rename -force $builddir/tcltkPapers.tar.gz $disdir}
        catch {file rename -force $builddir/tcltkPapers.tar.Z $disdir}

        file delete -force $builddir
    }

    TP_return_page {
        cgi_h2 "Download Area"
        cgi_p "Following distributions contain all of the papers, panels, demonstrations and posters under consideration for the [cgi_url {6th Annual Tcl/Tk Conference} http://www.usenix.org/events/tclPapers/]."
        cgi_bullet_list {
            foreach dfile $downloads {
		if {![file exists $dfile]} {
			p "Sorry, expected file $dfile does not exist."
			p "Contact [cgi_link admin] for help."
			continue
		}
                set size [expr [file size $dfile]/double(1024*1024)]
		set f [file tail $dfile]
#                cgi_li [cgi_url [file tail $f] $dispat/$f]
                cgi_li "<A href=$dispat/$f>$f</A><br>"
                cgi_put "([format %.2f $size] Mb)"
                cgi_br
                set date [clock format [file mtime $dfile]]
                cgi_put [cgi_font size=-1 "updated: [cgi_italic $date]"]
                cgi_p ""
            }
        }
        cgi_p "These files are the same, but they have been compressed in different formats."
        cgi_p "Each file contains a series of directories.  Each directory contains all of the information for one submission:"
        cgi_bullet_list {
            cgi_li "a cover letter"
            cgi_li "PostScript/PDF version of the submission"
            cgi_li "HTML or text version of the submission"
        }
    }
}
