#!/bin/sh
#\
exec /opt/tcl803/bin/tcl "$0"
# ----------------------------------------------------------------------
#  PURPOSE: Add/delete program committee members for Tcl/Tk Conference
# ----------------------------------------------------------------------
source cgi.tcl
source common.tcl
package require Tclgdbm
source tclPaperslib.tcl

cgi_name "DoPC"

# ----------------------------------------------------------------------
cgi_eval {
    cgi_input
    cgi_import action
    switch -- $action {
        Save {
            cgi_import name
            set name [string trim $name]
            if {[string length $name] == 0} {
                TP_return_error "Name missing for new committee member"
                cgi_exit
            }

            cgi_import email
            set email [string trim $email]
            if {![string match "?*@?*" $email]} {
                TP_return_error "Invalid e-mail address \"$email\" for new committee member"
                cgi_exit
            }

            #
            # Add/modify member in database
            #
            set db [gdbm open data/tclPapers.dat rwc]
		set all ""
            catch {set all [gdbm fetch $db "program-committee"]}
            if {[lsearch $all $name] < 0} {
                lappend all $name
                gdbm store $db "program-committee" $all
                gdbm store $db "pc-$name-review" ""
            }
            gdbm store $db "pc-$name-email" $email
            gdbm close $db

#            TP_regenerate . admin

            TP_return_page {
                cgi_p [cgi_font size=+2 "Saved: [cgi_bold $name]"]
            } 
        }

        Delete {

            cgi_import dname
	    set name $dname

            #
            # Delete member from database
            #

            set db [gdbm open data/tclPapers.dat rwc]
            set all [gdbm fetch $db "program-committee"]
            set i [lsearch $all $name]
            if {$i >= 0} {
                foreach token [gdbm fetch $db "pc-$name-review"] {
                    TP_reviewer_del $token $name
                }
                set all [lreplace $all $i $i]
                gdbm store $db "program-committee" $all
                gdbm delete $db "pc-$name-email"
                gdbm delete $db "pc-$name-review"
            }
            gdbm close $db

#            TP_regenerate . admin

            TP_return_page {
                cgi_p [cgi_font size=+2 "Deleted: [cgi_bold $name]"]
            } 
        }

        default {
            error "bad action \"$action\": should be Save or Delete"
        }
    }
}
