#!/bin/sh
#\
exec /opt/tcl803/bin/tcl "$0"
# ----------------------------------------------------------------------
#  PURPOSE: Handle review forms for Tcl/Tk Conference
# ----------------------------------------------------------------------
source cgi.tcl
source common.tcl
package require Tclgdbm
source tclPaperslib.tcl

cgi_name "DoRevform"

# ----------------------------------------------------------------------
cgi_eval {
    cgi_input
    cgi_import action
    cgi_import name

    if {"SELECT YOUR NAME" == $name} {
        TP_return_error "Select your name from the menu"
        cgi_exit
    }

    set all [TP_program_committee $name review]

    switch -- $action {
        "Get E-mail Form" {
            set db [gdbm open data/tclPapers.dat rwc]
            set papers [gdbm fetch $db "pc-$name-review"]
            gdbm close $db

            TP_return_page {
                cgi_p "Select all of the submissions that you want to review, then press [cgi_bold {Get Form}]."

                cgi_form DoRevform method=post {

                  cgi_table border=0 cellpadding=2 cellspacing=0 \
                    bgcolor=lemonchiffon {

                    cgi_export name
                    cgi_table_row {
                      cgi_table_data colspan=2 {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 size=+1 [cgi_bold \
                            "&nbsp;Build Review Form"]]
                        cgi_p ""
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "Reviewer:"]
                      }
                      cgi_table_data {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 [cgi_bold $name]]
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "&nbsp;Submissions:"]
                      }
                      cgi_table_data {
                        cgi_put "<font face=Lucida,Helvetica,Arial color=#000000>"
                        cgi_select titleList size=10 multiple {
                            foreach token [TP_submission_all] {
                                set title [TP_submission $token title]
                                if {[lsearch $papers $token] >= 0} {
                                    cgi_option $title selected
                                } else {
                                    cgi_option $title
                                }
                            }
                        }
                        cgi_put "&nbsp;</font>"
                      }
                    }
                    cgi_table_row {
                      cgi_table_data colspan=2 align=right {
                        cgi_put "<font face=Lucida,Helvetica,Arial color=#000000>"
                        cgi_submit_button "action=Get Form"
                        cgi_put "</font>"
                      }
                    }
                  }
                }
            }
        }

        "Get Form" {
            cgi_import name
            cgi_import titleList
            puts "Content-type: text/plain"
            puts "
>>> REVIEW FORM <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
>>> $TclConf <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
------------------------------------------------------------------------

Use this form to submit your review of papers, panels, demonstrations
and posters for the $TclConf.  Follow these
instructions:

  1) Save this form using the \"Save As...\" option under the
     \"File\" menu in your web browser.

  2) Fill in the form.

     !! EDIT ONLY IN THE AREAS MARKED TO INSERT YOUR RESULTS.
     !! LEAVE EVERYTHING ELSE INTACT.  This form is processed by
     !! an automatic registration program.  If you delete headings
     !! or make other significant changes, your reviews may not
     !! be recognized.

  3) Return this form to:  $ReviewsTo

  4) You should receive e-mail verification that your reviews were
     received, and your reviews should show up on the program committee
     web site : $MainPage

     You can downloading additional forms and repeat this process to
     submit additional reviews.

     If you encounter any problems, contact $WebMaster.


------------------------------------------------------------------------
  REVIEWER: $name"

            foreach title $titleList {
                puts "------------------------------------------------------------------------"
                puts "  TITLE: $title"
                puts ""
                puts "  Rate this paper on the following scale:"
                puts "    4.0 = This paper is excellent."
                puts "    3.0 = This paper is very good."
                puts "    2.0 = This paper is acceptable."
                puts "    1.0 = This paper is barely acceptable.  It requires lots of TLC"
                puts "          but I'm willing to risk accepting it."
                puts "    0.0 = This paper is unacceptable--too weak, unreadable,"
                puts "          inappropriate, out-of-date, etc."
                puts "     -1 = If this paper is accepted, I'll resign from the PC."
                puts ""
                puts "  SCORE: _______"
                puts "\n"
                puts "  How strongly do you feel about your score?"
                puts "    3.0 = No question about my score."
                puts "    2.0 = I feel pretty good about my score."
                puts "    1.0 = I think I'm right, but I could be totally off-base."
                puts "    0.0 = Ignore my score--I didn't have the background to judge"
                puts "          this paper, I have an irrational hatred of the topic,"
                puts "          the author stiffed me for taxi fare once, etc."

                if {[string compare $title [lindex $titleList 0]] == 0} {
                    puts "\n  NOTE: Don't be afraid to put down 3.0 for every paper if that's how"
                    puts "        you feel.  The whole reason you've been asked to review papers"
                    puts "        is because we respect your opinion.  Nonetheless, there are"
                    puts "        occasions when reviewers can't make heads or tails out of a paper"
                    puts "        and in that case, we'd like to automatically discount such scores."
                    puts "        At the same time, don't use this as a way of getting out of your"
                    puts "        responsibility to review papers--too many low weights leaves us"
                    puts "        in a tough spot and you will likely not be asked to serve on the"
                    puts "        PC again."
                }

                puts ""
                puts "  WEIGHT: __2.0__"

                puts "\n"
                puts "  SIGNIFICANT STRENGTHS OF THIS SUBMISSION:"
                puts "    ...put your comments here..."
                puts "\n"
                puts "  SIGNIFICANT WEAKNESSES OF THIS SUBMISSION:"
                puts "    ...put your comments here..."
                puts "\n"
                puts "  BOTTOM LINE: (why this paper should be accepted/rejected)"
                puts "    ...put your comments here..."
                puts "\n"
                puts "  OTHER NOTES TO THE AUTHOR:"
                puts "  (including typos, problems of clarity, suggestions for reorganization, etc.)"
                puts "    ...put your comments here..."
                puts "\n"
                puts "  PRIVATE COMMENTS TO OTHER PC MEMBERS:"
                puts "  These are the only comments that will not be seen by the author."
                puts "  For example, comments mentioning other submissions should go here."
                puts "    ...put your comments here..."
                puts "\n"
            }
            exit
        }

        "Use Online Form" {
            TP_return_page {
                cgi_p {
Each member of the program committee is assigned certain papers,
panels, and demonstrations to review.  Feel free to contribute
additional reviews if you are inspired.  The review information will
be mailed back to you when you submit the form.  If you want to amend
a review, just submit another one.
}
                cgi_form DoReview method=post {

                  cgi_table border=0 cellpadding=2 cellspacing=0 \
                    bgcolor=lemonchiffon {

                    cgi_export name
                    cgi_table_row {
                      cgi_table_data colspan=2 {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 size=+1 [cgi_bold \
                            "&nbsp;Review"]]
                        cgi_p ""
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "Reviewer:"]
                      }
                      cgi_table_data {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 [cgi_bold $name]]
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "&nbsp;Submission:"]
                      }
                      cgi_table_data {
                        cgi_put "<font face=Lucida,Helvetica,Arial color=#000000>"
                        cgi_select title size=5 {
                            foreach token [TP_submission_all] {
                                set title [TP_submission $token title]
                                cgi_option $title
                            }
                        }
                        cgi_put "</font>"
                      }
                    }
                    cgi_table_row bgcolor=ivory {
                      cgi_td colspan=2 { &nbsp; }
                    }
                    cgi_table_row {
                      cgi_td { &nbsp; }
                      cgi_table_data align=left valign=top {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "Rate this paper on the following scale:"]
                        cgi_blockquote [cgi_buffer {
                          cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                              color=#000000 "4.0 = This paper is excellent."]
                          cgi_br
                          cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                              color=#000000 "3.0 = This paper is very good."]
                          cgi_br
                          cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                              color=#000000 "2.0 = This paper is acceptable."]
                          cgi_br
                          cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                              color=#000000 "1.0 = This paper is barely acceptable.  It requires lots of TLC but I'm willing to risk accepting it."]
                          cgi_br
                          cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                              color=#000000 "0.0 = This paper is unacceptable--too weak, unreadable, inappropriate, out-of-date, etc."]
                          cgi_br
                          cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                              color=#000000 "-1 = If this paper is accepted, I'll resign from the PC."]
			}]
                        
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "Score:"]
                      }
                      cgi_table_data {
                        cgi_text score= size=10
                      }
                    }
                    cgi_table_row bgcolor=ivory {
                      cgi_td colspan=2 { &nbsp; }
                    }
                    cgi_table_row {
                      cgi_td { &nbsp; }
                      cgi_table_data align=left {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "How strongly do you feel about your score?  Don't be afraid to put down 3.0 for every paper if that's how you feel.  The whole reason you've been asked to review papers is because we respect your opinion.  Nonetheless, there are occasions when reviewers can't make heads or tails out of a paper and in that case, we'd like to automatically discount such scores.  At the same time, don't use this as a way of getting out of your responsibility to review papers--too many low weights leaves us in a tough spot and you will likely not be asked to serve on the PC again."]
                        cgi_blockquote [cgi_buffer {
                          cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                              color=#000000 "3.0 = No question about my score"]
                          cgi_br
                          cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                              color=#000000 "2.0 = I feel pretty good about my score"]
                          cgi_br
                          cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                              color=#000000 "1.0 = I think I'm right, but I could be totally off-base"]
                          cgi_br
                          cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                              color=#000000 "0.0 = Ignore my score--I didn't have the background to judge this paper, I have an irrational hatred of the topic, the author stiffed me for taxi fare once, etc."]
                        }]
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "Weight:"]
                      }
                      cgi_table_data {
                        cgi_text multiplier=2.0 size=10
                      }
                    }
                  }

                  cgi_p
                  cgi_put [cgi_bold "Significant Strengths of this Submission:"]
                  cgi_br
                  cgi_textarea strengths= cols="75" rows="10"

                  cgi_p
                  cgi_put [cgi_bold "Significant Weaknesses of this Submission:"]
                  cgi_br
                  cgi_textarea weaknesses= cols="75" rows="10"

                  cgi_p
                  cgi_put [cgi_bold "Bottom Line:"]
                  cgi_put " (why this paper should be accepted/rejected)"
                  cgi_br
                  cgi_textarea bottomline= cols="75" rows="10"

                  cgi_p
                  cgi_put [cgi_bold "Other Notes to the Author"]
                  cgi_put " (including typos, problems of clarity, suggestions for reorganization, etc.)"
                  cgi_br
                  cgi_textarea comments= cols="75" rows="10"

                  cgi_p
                  cgi_put [cgi_bold "Private Comments to Other PC Members:"]
                  cgi_br
                  cgi_put "These are the only comments that will not be seen by the author."
                  cgi_br
                  cgi_put "For example, comments mentioning other submissions should go here."
                  cgi_br
                  cgi_textarea private= cols="75" rows="10"

                  cgi_p
                  cgi_submit_button action=Submit
                  cgi_put "&nbsp;&nbsp;&nbsp;&nbsp;"
                  cgi_reset_button
                }
            } "Online Review Form"
        }

        default {
            error "bad action \"$action\": should be \"Get E-mail Form\" or \"Use Online Form\""
        }
    }
}
