#!/bin/sh
#\
exec /opt/tcl803/bin/tcl "$0"
# ----------------------------------------------------------------------
#  PURPOSE: Save reviews for Tcl/Tk Conference
# ----------------------------------------------------------------------
source cgi.tcl
source common.tcl
package require Tclgdbm
source tclPaperslib.tcl

cgi_name "DoReview"

# ----------------------------------------------------------------------
cgi_eval {
    cgi_input
    cgi_import action
    switch -- $action {
        Submit {
            cgi_import name
            set reviewer $name

            if {[catch {cgi_import title}] != 0} {
                TP_return_error "Select a title for the paper that you're reviewing."
                cgi_exit
            }
            set paper [TP_submission_find $title]

            if {[catch {cgi_import score}] != 0} {
                TP_return_error "Enter a numerical score for the paper that you're reviewing."
                cgi_exit
            }
            if {[catch {expr 1*$score}] != 0 || $score < -1 || $score > 4} {
                TP_return_error "Bad score \"$score\" (should be a number from -1 to 4)"
                cgi_exit
            }

            if {[catch {cgi_import multiplier}] != 0} {
                TP_return_error "Enter a numerical weight for the paper that you're reviewing."
                cgi_exit
            }
            if {[catch {expr 1*$multiplier}] != 0 || $multiplier < 0 || $multiplier > 3} {
                TP_return_error "Bad multiplier weight \"$multiplier\" (should be a number from 0 to 3)"
                cgi_exit
            }

            if {[catch {cgi_import strengths}] != 0} {
                set strengths ""
            }
            set strengths [string trim $strengths]

            if {[catch {cgi_import weaknesses}] != 0} {
                set weaknesses ""
            }
            set weaknesses [string trim $weaknesses]

            if {[catch {cgi_import bottomline}] != 0} {
                set bottomline ""
            }
            set bottomline [string trim $bottomline]

            if {[catch {cgi_import comments}] != 0} {
                set comments ""
            }
            set comments [string trim $comments]

            if {[catch {cgi_import private}] != 0} {
                set private ""
            }
            set private [string trim $private]

            if {[TP_reviewed $paper $reviewer]} {
                if {[catch {TP_review_del $paper $reviewer} mesg] != 0} {
                    TP_return_error $mesg
                    cgi_exit
                }
            }

            #
            # Create a new review record.
            #
            set db [gdbm open data/tclPapers.dat rwc]
            set id [gdbm fetch $db "identifier"]
            if {"" == $id} {set id 0}
            incr id
            gdbm store $db "identifier" $id
            set token "review$id"

            set email ""
            if {[gdbm exists $db "pc-$name-email"]} {
                set email [gdbm fetch $db "pc-$name-email"]
            }

            gdbm store $db "$token-title" $title
            gdbm store $db "$token-reviewer" $name
            gdbm store $db "$token-score" $score
            gdbm store $db "$token-multiplier" $multiplier
            gdbm store $db "$token-strengths" $strengths
            gdbm store $db "$token-weaknesses" $weaknesses
            gdbm store $db "$token-bottomline" $bottomline
            gdbm store $db "$token-comments" $comments
            gdbm store $db "$token-private" $private

            set htmlfile "$reviewsDir/$token.html"
            gdbm store $db "$token-html" $htmlfile

            set authors [gdbm fetch $db "$paper-authors"]

            #
            # Register review and compute average score.
            #
            if {"" != $paper} {
                set all [gdbm fetch $db "$paper-reviews"]
                lappend all $token
                gdbm store $db "$paper-reviews" $all

                set total 0
                set mtotal 0
                foreach rev $all {
                    set sval [gdbm fetch $db "$rev-score"]
                    set mval [gdbm fetch $db "$rev-multiplier"]
                    if {"" != $sval} {
                        set total [expr $total + $sval*$mval]
                        set mtotal [expr $mtotal + $mval]
                    }
                }
                if {$mtotal == 0} {
                    set avg ""
                } else {
                    set avg [format "%.2f" [expr double($total)/$mtotal]]
                }
                gdbm store $db "$paper-score" $avg
            }
            gdbm close $db

#	the global var Testing disables noisy features that could
#	embarrass you while testing the suite.

	    if $Testing {set email $WebMaster}

            if {"" != $email} {
                cgi_mail_addr $ReviewsTo
                cgi_mail_start $email
		if !$Testing {
                cgi_mail_add "Cc: $ReviewsTo"
		}
                cgi_mail_add "Subject: Review for Tcl/Tk 'Papers"
                cgi_mail_add "
Thanks for your review of the following submission.  This note is
your record that the review has been received and processed.

        TITLE: $title
      AUTHORS: $authors
        SCORE: $score
       WEIGHT: $multiplier

SIGNIFICANT STRENGTHS OF THIS SUBMISSION:
$strengths


SIGNIFICANT WEAKNESSES OF THIS SUBMISSION:
$weaknesses


BOTTOM LINE:
$bottomline


OTHER NOTES TO THE AUTHOR:
$comments


PRIVATE COMMENTS TO OTHER PC MEMBERS:
$private


--> $TclChairs
--> Program Chairs for $TclConf
"
                catch {cgi_mail_end}
            }

            TP_regenerate . admin

            #
            # Save HTML for review.
            #
	    # this is local file ref
            set fid [open "$HTMLDIR/$reviewsDir/template.html" r]
            set body [read $fid]
            close $fid

            foreach field {strengths weaknesses bottomline comments private} {
                set $field [cgi_quote_html [set $field]]
                regsub -all "\n\[ \t\]*\n" [set $field] "\n<p>" $field
            }

            foreach field {
                title reviewer score multiplier
                strengths weaknesses bottomline comments private
            } {
                set replace [set $field]
                regsub -all "&" $replace "\\\\&" replace
                regsub -all "@[string toupper $field]@" $body $replace body
            }

#	    get the review number as well -- why did this appear to fail?
	    regsub -all "@REVNO@" $body $token body

            set fid [open $HTMLDIR/$htmlfile w]
            puts $fid $body
            close $fid

            #
            # Return a confirmation.
            #
            TP_return_page {
                cgi_put [cgi_font size="+2" [cgi_bold "Review accepted"]]
                cgi_p ""

                cgi_table border=0 cellpadding=5 cellspacing=0 {
                    cgi_table_row {
                        cgi_table_data align=right {
                            cgi_put [cgi_bold Title]
                        }
                        cgi_table_data {
                            cgi_put $title
                        }
                    }
                    cgi_table_row {
                        cgi_table_data align=right {
                            cgi_put [cgi_bold Score]
                        }
                        cgi_table_data {
                            cgi_put $score
                        }
                    }
                    cgi_table_row {
                        cgi_table_data align=right {
                            cgi_put [cgi_bold Weight]
                        }
                        cgi_table_data {
                            cgi_put $multiplier
                        }
                    }
                }
                if {"" != $email} {
                    cgi_p "You'll receive a summary of your review via e-mail at [cgi_bold $email]"
                }
            }
        }

        Delete {
            if {[catch {cgi_import name}] != 0 || $name == "SELECT A REVIEWER"} {
                TP_return_error "Select the name of a reviewer"
                cgi_exit
            }
            if {[catch {cgi_import title}] != 0} {
                TP_return_error "Select a title of the paper for the desired review"
                cgi_exit
            }

            set paper [TP_submission_find $title]
            if {"" == $paper} {
                TP_return_error "Can't find paper \"$title\""
                cgi_exit
            }

            if {[catch {TP_review_del $paper $name} mesg] != 0} {
                TP_return_error $mesg
                cgi_exit
            }

#            TP_regenerate . admin

            TP_return_page {
                cgi_p [cgi_font size=+2 [cgi_bold "Deleted review"]]
                cgi_table border=0 cellpadding=5 cellspacing=0 {
                    cgi_table_row {
                        cgi_table_data align=right {
                            cgi_put [cgi_bold Title]
                        }
                        cgi_table_data {
                            cgi_put $title
                        }
                    }
                    cgi_table_row {
                        cgi_table_data align=right {
                            cgi_put [cgi_bold Reviewer]
                        }
                        cgi_table_data {
                            cgi_put $name
                        }
                    }
                }
                cgi_p "loading..."
            } {
                cgi_meta http-equiv=refresh "content=1\;url=$BASE/admin/review.html"
            }
        }

        default {
            error "bad action \"$action\": should be Submit or Delete"
        }
    }
}
