#!/bin/sh
#\
exec /opt/tcl803/bin/tcl "$0"
# ----------------------------------------------------------------------
#  PURPOSE: Add/delete submissions for Tcl/Tk Conference
# ----------------------------------------------------------------------
source cgi.tcl
source common.tcl
package require Tclgdbm
source tclPaperslib.tcl

cgi_name "DoSubmit"
set WhichLogo Admin

# ----------------------------------------------------------------------
cgi_eval {
    cgi_input
    cgi_import action
    switch -- $action {
        Add {
            cgi_import type
            cgi_import title
	    set remote [cgi_import_filename -remote cover]
#	    p "remote cover file is $remote"

            set title [string trim $title]
            if {[string length $title] == 0} {
                TP_return_error "Title missing for new submission"
                cgi_exit
            }

            cgi_import authors
            cgi_import email
            cgi_import status

            set token [TP_submission_find $title]
            if {"" != $token} {
                TP_return_error "Title \"$title\" is already used by another submission"
                cgi_exit
            }

            #
            # Make sure that filenames are all unique.
            #
            set error 0
            set fnames ""
            foreach field {cover postscript postscript2 html html2} {
		set remote [cgi_import_filename -remote $field]
                set tail [file tail $remote]
                if {[lsearch $fnames $tail] >= 0} {
                    set error 1
                    break
                }
                if {[string length $tail] > 0} {
                    lappend fnames $tail
                }
            }

            if {$error} {
                foreach field {cover postscript postscript2 html html2} {
                    set local [cgi_import_filename -local $field]
                    file delete -force $local
                }
                TP_return_error "Upload files have the same name \"$tail\""
                cgi_exit
            }

            #
            # Add submission to database
            #
            set db [gdbm open data/tclPapers.dat rwc]
		set id ""
            catch {set id [gdbm fetch $db "identifier"]}
            if {"" == $id} {set id 0}
            incr id
            gdbm store $db "identifier" $id
            set token "submit$id"

            #
            # Upload files into storage
            #
            set adir $HTMLDIR/$submissDir/$token
            set rdir $submissDir/$token

#	make abs dir and chmod
            file mkdir $adir
            catch {exec chmod ugo+rwx $adir}

#	store rel dir in db but copy to abs dir
            foreach field {cover postscript postscript2 html html2} {
                set local [cgi_import_filename -local $field]
                set remote [cgi_import_filename -remote $field]
                set files($field) ""
                if {[string length $remote] > 0} {
                    set files($field) [file join $rdir [file tail $remote]]
                    file copy $local $HTMLDIR/$files($field)
                }
                file delete -force $local
            }

            #
            # Create new submission record
            #
	    set all ""
            catch {set all [gdbm fetch $db "$type"]}
            lappend all $token
            gdbm store $db "$type" $all

	    set all ""
            catch {set all [gdbm fetch $db "submissions"]}
            lappend all $token
            gdbm store $db "submissions" $all

            gdbm store $db "$token-type" $type
            gdbm store $db "$token-title" $title
            gdbm store $db "$token-authors" $authors
            gdbm store $db "$token-email" $email
            gdbm store $db "$token-cover" $files(cover)
            gdbm store $db "$token-postscript" $files(postscript)
            gdbm store $db "$token-postscript2" $files(postscript2)
            gdbm store $db "$token-html" $files(html)
            gdbm store $db "$token-html2" $files(html2)
            gdbm store $db "$token-status" $status
            gdbm store $db "$token-reviewers" ""
            gdbm store $db "$token-reviews" ""
            gdbm store $db "$token-score" ""
            gdbm close $db

            #
            # Send an e-mail notification.
            #
            if {"" != $email} {
                set cmds {
                    set fid [open receive.txt "r"]
                    set body [read $fid]
                    close $fid
                }
                if {[catch $cmds] == 0} {
                    cgi_mail_addr tclPaperspapers@usenix.org
                    cgi_mail_start $email
                    regsub -all @TITLE@ $body $title body
                    cgi_mail_add $body
                    catch {cgi_mail_end}
                }
            }

#            TP_regenerate . admin

            TP_return_page {
                cgi_p [cgi_font size=+2 "Successfully Submitted: [cgi_bold $title]"]
            } 
        }

        Modify {
            if {[catch {cgi_import title}] != 0} {
                TP_return_error "Select a title"
                cgi_exit
            }

            set token [TP_submission_find $title]
            if {"" == $token} {
                TP_return_error "Can't find token for submission \"$title\""
                cgi_exit
            }

            set db [gdbm open data/tclPapers.dat rwc]
            set type [gdbm fetch $db "$token-type"]
            set title [gdbm fetch $db "$token-title"]
            set authors [gdbm fetch $db "$token-authors"]
            set email [gdbm fetch $db "$token-email"]
            set cover [gdbm fetch $db "$token-cover"]
            set postscript [gdbm fetch $db "$token-postscript"]
            set postscript2 [gdbm fetch $db "$token-postscript2"]
            set html [gdbm fetch $db "$token-html"]
            set html2 [gdbm fetch $db "$token-html2"]
            set status [gdbm fetch $db "$token-status"]
            gdbm close $db

            TP_return_page {
                cgi_table border=0 cellpadding=2 cellspacing=0 bgcolor=antiquewhite {
                  cgi_form DoSubmit method=post {
                    cgi_export token
                    cgi_table_row {
                      cgi_table_data colspan=2 {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 size=+1 [cgi_bold \
                            "&nbsp;Modify Submission"]]
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "Type"]
                      }
                      cgi_table_data {
                        cgi_put "<font face=Lucida,Helvetica,Arial color=#000000>"
                        cgi_select type {
                            foreach opt {paper panel demonstration poster} {
                                cgi_option $opt selected_if_equal=$type
                            }
                        }
                        cgi_put "</font>"
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "Title"]
                      }
                      cgi_table_data {
                        cgi_text title=$title size=40
                        cgi_put "&nbsp;"
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "Authors"]
                      }
                      cgi_table_data {
                        cgi_text authors=$authors size=40
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "E-mail"]
                      }
                      cgi_table_data {
                        cgi_text email=$email size=40
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "&nbsp;Cover Letter"]
                      }
                      cgi_table_data {
                        cgi_text cover=$cover size=40
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "&nbsp;PostScript/PDF"]
                      }
                      cgi_table_data {
                        cgi_text postscript=$postscript size=40
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "HTML/text"]
                      }
                      cgi_table_data {
                        cgi_text html=$html size=40
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "&nbsp;Poster Draft (ps)"]
                      }
                      cgi_table_data {
                        cgi_text postscript2=$postscript2 size=40
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "&nbsp;Poster Draft (html)"]
                      }
                      cgi_table_data {
                        cgi_text html2=$html2 size=40
                      }
                    }
                    cgi_table_row {
                      cgi_table_data align=right {
                        cgi_put [cgi_font face=Lucida,Helvetica,Arial \
                            color=#000000 "Status"]
                      }
                      cgi_table_data {
                        cgi_text status=$status size=40
                      }
                    }
                    cgi_table_row {
                      cgi_table_data colspan=2 align=right {
                        cgi_put "<font face=Lucida,Helvetica,Arial color=#000000>"
                        cgi_submit_button action=Save
                        cgi_put "</font>&nbsp;"
                      }
                    }
                  }
                }
            }
        }

        Save {
            cgi_import token
            cgi_import type
            cgi_import title
            cgi_import authors
            cgi_import email
            cgi_import cover
            cgi_import postscript
            cgi_import postscript2
            cgi_import html
            cgi_import html2
            cgi_import status

            set db [gdbm open data/tclPapers.dat rw]
            gdbm store $db "$token-type" $type
            gdbm store $db "$token-title" $title
            gdbm store $db "$token-authors" $authors
            gdbm store $db "$token-email" $email
            gdbm store $db "$token-cover" $cover
            gdbm store $db "$token-postscript" $postscript
            gdbm store $db "$token-postscript2" $postscript2
            gdbm store $db "$token-html" $html
            gdbm store $db "$token-html2" $html2
            gdbm store $db "$token-status" $status
            gdbm close $db

#            TP_regenerate . admin

            TP_return_page {
                cgi_p [cgi_font size=+2 "Altered: [cgi_bold $title]"]
            } 
        }

        Delete {
            if {[catch {cgi_import title}] != 0} {
                TP_return_error "Select a title"
                cgi_exit
            }
            cgi_import prompt

            if {$prompt != 0} {
                TP_return_page {
                    cgi_p "Once a submission is deleted, it cannot be restored."
                    cgi_p "Do you really want to delete [cgi_bold $title]?"
                    cgi_form DoSubmit method=post {
                        set prompt 0
                        cgi_export prompt
                        cgi_export title
                        cgi_submit_button action=Delete
                    }
                }
                cgi_exit
            }

            set token [TP_submission_find $title]
            if {"" == $token} {
                TP_return_error "Can't find submission \"$title\""
                cgi_exit
            }

            set db [gdbm open data/tclPapers.dat rwc]
            set type [gdbm fetch $db "$token-type"]
            set all [gdbm fetch $db "$type"]
            set i [lsearch $all $token]
            if {$i >= 0} {
                set all [lreplace $all $i $i]
            }
            gdbm store $db "$type" $all

            set all [gdbm fetch $db "submissions"]
            set i [lsearch $all $token]
            if {$i >= 0} {
                set all [lreplace $all $i $i]
            }
            gdbm store $db "submissions" $all

            foreach name [gdbm fetch $db "$token-reviewers"] {
                TP_reviewer_del $token $name
            }

            foreach field {cover postscript postscript2 html html2} {
                set file [gdbm fetch $db "$token-$field"]
                if {[file exists $file]} {
                    file delete -force $file
                }
            }
            if {[file exists submissions/$token]} {
                file delete -force submissions/$token
            }

            gdbm delete $db "$token-type"
            gdbm delete $db "$token-title"
            gdbm delete $db "$token-authors"
            gdbm delete $db "$token-email"
            gdbm delete $db "$token-cover"
            gdbm delete $db "$token-postscript"
            gdbm delete $db "$token-postscript2"
            gdbm delete $db "$token-html"
            gdbm delete $db "$token-html2"
            gdbm delete $db "$token-status"
            gdbm delete $db "$token-reviewers"
            gdbm delete $db "$token-reviews"
            gdbm delete $db "$token-score"

            gdbm close $db

#            TP_regenerate . admin

            TP_return_page {
                cgi_p [cgi_font size=+2 "Deleted: [cgi_bold $title]"]
            } 
        }

        default {
            error "bad action \"$action\": should be Add, Modify, Save or Delete"
        }
    }
}
