#!/opt/tcl803/bin/tcl

# first, get the goodies you need
#
source cgi.tcl
source common.tcl
package require Tclgdbm
#
# this should start a safe interp
#
source tclPaperslib.tcl
set WhichLogo Admin
#
set vlist [list title name email affiliation overview]
array set varlabels {
	title Title
	name "Presenter's Name"
	email E-Mail
	affiliation "Affiliation"
	overview "Brief Description"
}
#
set db [gdbm open $DataFile r]
set all ""
set demos ""
catch {set all [gdbm fetch $db "demos"]}
foreach d $all {
	set t [gdbm fetch $db $d-title]
	lappend demos $t
}
gdbm close $db
set demos [lsort $demos]
#
cgi_eval {

    source common.tcl

    cgi_title "$TclNick Administration: Demos"

    # use targets if we are framed
    if {0==[catch {cgi_import framed}]} {
        set target "target=script"
    } else {
        set target ""
    }

    proc script {name} {
        global target
        cgi_url "$name.cgi" [cgi_cgi $name] $target
    }

    cgi_body {


        cgi_table border=0 cellpadding=4 cellspacing=0 {

                cgi_table_row {

                cgi_table_data { cgi_imglink Blank}
        
                cgi_table_data valign="top" width="100%" {

#               p "[cgi_imglink ProgComm.gif]"

                cgi_br 


		p "So far we have [llength $demos] Informal Demo(s):"
		show_demo_list  
		p "You can use this form to maintain the list of Demos...  remember, there is no Undo." 
                cgi_table border=0 cellpadding=0 cellspacing=8 bgcolor=lemonchiffon {

#	START FORM A:  add/mod
		cgi_form DoDemos {

		cgi_table_row {
			cgi_table_data colspan=2 {
				h2 "Add/Modify a Demo"
			}
		}

		foreach v $vlist {
		cgi_table_row {
		td "$ss0 $varlabels($v) $ef"
		cgi_table_data {
			cgi_text ${v}= size=40 
		}
		}
		}

#	END of INPUT ROWS

		cgi_table_row {
		cgi_table_data {
			cgi_submit_button action=Add
		}
		cgi_table_data {
			cgi_submit_button action=Modify
		}
    		}

		}

#		END FORM A
	
#		START FORM B:  Delete

		cgi_form DoDemos {
			cgi_export prompt=1
			cgi_table_row {
				cgi_table_data colspan=2 {
				h2 "Delete a Demo"
				}
			}
			cgi_table_row {
				td "$ss0 Title $ef"
				cgi_table_data colspan=2 {
				cgi_select title {
					foreach t $demos {
					cgi_option $t
					}
				}
				}
			}
			cgi_table_row {
				cgi_table_data colspan=2 {
				cgi_submit_button action=Delete
				}
			}

		}
#		END of FORM B

		}
#		END OF INNER TABLE

		}
#		END OF CELL

		}
#		END OF ROW
	}
#	END OUTER TABLE

    }
#   END BODY

}
# END EVAL
