#!/opt/tcl803/bin/tcl

# first, get the goodies you need
#
source cgi.tcl
source common.tcl
package require Tclgdbm
#
# this should start a safe interp
#
source tclPaperslib.tcl
set WhichLogo Admin
#
set vlist [list title name email affiliation overview time]
array set varlabels {
	title Title
	name Name
	email E-Mail
	affiliation "Affiliation"
	overview "Brief Description"
	time "Time Slot"
}
#
set db [gdbm open $DataFile r]
set all ""
set wipses ""
catch {set all [gdbm fetch $db "wips"]}
foreach w $all {
	set t [gdbm fetch $db $w-title]
	lappend wipses $t
}
gdbm close $db
set wipses [lsort $wipses]
#
cgi_eval {

    source common.tcl

    cgi_title "$TclNick Administration: WIPS"

    # use targets if we are framed
    if {0==[catch {cgi_import framed}]} {
        set target "target=script"
    } else {
        set target ""
    }

    proc script {name} {
        global target
        cgi_url "$name.cgi" [cgi_cgi $name] $target
    }

    cgi_body {


        cgi_table border=0 cellpadding=4 cellspacing=0 {

                cgi_table_row {

                cgi_table_data { cgi_imglink Blank}
        
                cgi_table_data valign="top" width="100%" {

#               p "[cgi_imglink ProgComm.gif]"

                cgi_br 


		p "So far we have [llength $wipses] WIPS:"
		show_wips_list  
		p "You can use this form to maintain the list of WIPS...  remember, there is no Undo." 
                cgi_table border=0 cellpadding=0 cellspacing=8 bgcolor=lemonchiffon {

#	START FORM A:  add/mod
		cgi_form DoWips {

		cgi_table_row {
			cgi_table_data colspan=2 {
				h2 "Add/Modify a WIPS"
			}
		}

		foreach v $vlist {
		cgi_table_row {
		td "$ss0 $varlabels($v) $ef"
		cgi_table_data {
			cgi_text ${v}= size=40 
		}
		}
		}

#	END of INPUT ROWS

		cgi_table_row {
		cgi_table_data {
			cgi_submit_button action=Add
		}
		cgi_table_data {
			cgi_submit_button action=Modify
		}
    		}

		}

#		END FORM A
	
#		START FORM B:  Delete

		cgi_form DoWips {
			cgi_export prompt=1
			cgi_table_row {
				cgi_table_data colspan=2 {
				h2 "Delete a WIPS"
				}
			}
			cgi_table_row {
				td "$ss0 Title $ef"
				cgi_table_data colspan=2 {
				cgi_select title {
					foreach t $wipses {
					cgi_option $t
					}
				}
				}
			}
			cgi_table_row {
				cgi_table_data colspan=2 {
				cgi_submit_button action=Delete
				}
			}

		}
#		END of FORM B

		}
#		END OF INNER TABLE

		}
#		END OF CELL

		}
#		END OF ROW
	}
#	END OUTER TABLE

    }
#   END BODY

}
# END EVAL
