# common definitions for this web
# Tcl2K paper review web
#
# cgi_debug -on
#
# Servers
#
set SunW3 http://sunscript.sun.com/research/tcl
set NeoW3 http://www.neosoft.com
set NeoFTP ftp://ftp.neosoft.com/pub/tcl
set NeoArc ftp://ftp.neosoft.com/pub/tcl/sorted
set TclTkW3 http://www.tcltk.com
set LickW3 http://www.ucolick.org
set LickFTP ftp://ftp.ucolick.org/pub
set TclFTP $LickFTP/src/UCODB
set LuceFTP ftp://research.att.com
set NistW3 http://www.mel.nist.gov
set NyxW3 http://www.nyx.net
set TConW3 http://www.tclconsortium.org
set Usenx http://www.usenix.org
#
# People and Lick resources WWW
#
set DeW3  $LickW3/~de
set TclW3 $DeW3/Tcl
set TomW3 $NyxW3/~tpoindex
set DonW3 $NistW3/msidstaff/libes
set Tcl2K $LickW3/cgi-bin/Tcl2K
set De2K $DeW3/Tcl2K
set Usenix $Usenx/events/tcl2k
set TechProgram $TConW3/tcl2K/program.html
set TutSched $TConW3/tcl2K/tutorials.html
#
# extension and product WWW
#
set ExpW3 $DonW3
set BltW3 $TclTkW3/blt
set CgiW3 $NistW3/cgi.tcl
set CgiDemo $DeW3/Tcl/CGIdemo.html
set TCon2K $TConW3/tcl2k
#
# Online Reference
#
cgi_link TutSched "Tutorial Schedule" $Tcl2K/tutorials.cgi
cgi_link BLT "BLT Tcl/Tk Extension" $TclTkW3
cgi_link ITcl "Incr Tcl Tcl/Tk Extension" $TclTkW3
cgi_link TclXMan "TclX Reference Manual" http://www-sdss.fnal.gov:8000/dss/doc/www/tcl/tclx.html
#
# extension and product FTP
#
# just one example
#
set oraFTP $NeoArc/databases/oratcl-2.4
cgi_link OraFTP "OraTcl Extension" $oraFTP
#
# pretty gifs
#
set TclFeather $DeW3/TclFeather.gif
set TclAnim $DeW3/FeatherAnim.gif
set TclTkLogo $DeW3/TclTk.gif
set TclPower $DeW3/TclPowered.gif
# set TclMarble $Tcl2K/images/tcl2kA.gif
# set TclGlow $Tcl2K/images/tcl2kB.gif
#
# Hack for displaying plaintext files
#
set DisplayMe $LickW3/cgi-bin/Tcl/display.cgi?scriptname=
#
# You know who I am
#
cgi_admin_mail_addr de@ucolick.org
cgi_link Webmaster "Webmaster@ucolick.org" mailto:webmaster@ucolick.org
cgi_link DeMail "De Clarke (de@ucolick.org)" mailto:de@ucolick.org
#
# Unless otherwise set by individual apps
cgi_name Tcl2K
#
set TOP target=_top
#
# cgi_link Lucent	  "Lucent Technologies"		$LuceW3
cgi_link TomP	  "Tom Poindexter"		$TomW3
cgi_link DonL	  "Don Libes"			$DonW3
cgi_link De	  "De Clarke"			$DeW3
cgi_link admin    "Webmaster"			mailto:[cgi_admin_mail_addr]
cgi_link Cgitcl   "CGItcl homepage"             $CgiW3 $TOP
cgi_link CGIdemo  "CGI-Tcl Demo Pages"		$CgiDemo
cgi_link Usenix   "Upcoming Tcl/Tk Conference"  $Usenix
cgi_link TechProgram "Technical Program Schedule" $TechProgram
# cgi_link TutSched "Tutorial Program Schedule" $TutSched
#
#	Typical screen snapshots and other illustrations
#
set tclpcAdmin   	$De2K/images/admin.gif
set tclpcBack  		$De2K/images/Dback.gif 
set tclpcBackGnd   	$De2K/images/transFeather.jpg
set tclpcBlank   	$De2K/images/blank.gif
set tclpcBracket   	$De2K/images/bracket.gif
set tclpcBullet   	$De2K/images/bullet.gif
set tclpcCheck  	$De2K/images/check.gif
set tclpcConsortium  	$De2K/images/consortium.gif
set tclpcError   	$De2K/images/error.gif
set tclpcLucent  	$De2K/images/lucent.gif
set tclpcProgComm    	$De2K/images/pc.gif  
set tclpcWebnet   	$De2K/images/webnet.gif
set tclMarble		$De2K/images/tcl2kA.gif
set tclGlow		$De2K/images/tcl2kB.gif
set bwFeather		$De2K/images/bwFeather.gif
#
cgi_imglink Admin $tclpcAdmin	alt="Admin Logo"
cgi_imglink Back $tclpcBack  	alt="Go Back to Top"
cgi_imglink BackGnd $tclpcBackGnd   	
cgi_imglink Blank $tclpcBlank   	width=120 border=0
cgi_imglink Bracket $tclpcBracket   	
cgi_imglink Bullet $tclpcBullet   	
cgi_imglink Check $tclpcCheck  	
cgi_imglink Consortium $tclpcConsortium  
cgi_imglink Error $tclpcError   	
cgi_imglink Lucent $tclpcLucent  	
cgi_imglink ProgComm $tclpcProgComm    alt="Program Committee"
cgi_imglink Webnet $tclpcWebnet   	
cgi_imglink TclMarble $tclMarble
cgi_imglink TclGlow $tclGlow
#
cgi_imglink Feather $bwFeather alt="The Tcl Logo" width=70 height=90
cgi_imglink TclAnim $TclAnim alt="The Tcl Logo Movie"
cgi_imglink Powered $TclPower alt="Powered by Tcl"
cgi_imglink TclTkLogo $TclTkLogo alt="Tcl/Tk"
#
#
cgi_link KSD98      "Tcl/Tk/KTL Interface (PostScript)"		$DeW3/KSD/ksd98.ps
cgi_link WisqlPics "Wisql Photo Gallery"	$TclW3/pictures/Wisql.html
#
# TWO DIFFERENT BACK BUTTONS
cgi_link Start    [cgi_imglink Back]	"[cgi_cgi index]"
cgi_link AdStart    [cgi_imglink Back]	"[cgi_cgi admin]"
#
# COMMITTEE STUFF
cgi_link ShowMe	  "Submissions"		[cgi_cgi showme]
cgi_link Panels	  "Panels"		[cgi_cgi panels]
cgi_link Papers   "Papers"		[cgi_cgi papers]
cgi_link Posters  "Posters"		[cgi_cgi posters]
cgi_link Posters  "Demos"		[cgi_cgi demos]
cgi_link Reviewers  "Reviewers"		[cgi_cgi reviewers]
cgi_link TutSched  "Tutorial Program Schedule" [cgi_cgi tutorials]
cgi_link Review	  "Review Form"			[cgi_cgi review]
#
# ADMIN STUFF
cgi_link Admin    "Administration"		[cgi_cgi admin]
cgi_link Committee "Manage Committee"		[cgi_cgi pc]
cgi_link Submit   "Add/Delete Papers"		[cgi_cgi submit]
cgi_link adDemos    "Manage Demos"		[cgi_cgi addemos]
cgi_link adWIPS "Manage WIPS"			[cgi_cgi adwips]
cgi_link Assign "Assign Reviewers"		[cgi_cgi assign]
cgi_link upload "Upload Files Test"		[cgi_cgi upload]
#
# Allow for both my development and production environment.  And people
# who copy this to their own server and fail to change cgi_root will get
# my production environment!
cgi_root "$LickW3/cgi-bin/Tcl2K"
#
proc scriptlink {} {
    if {0==[catch {cgi_import framed}]} {
	set target "target=script"
    } else {
	set target ""
    }

    cgi_url "the Tcl script" [cgi_cgi display scriptname=[info script]] $target
}
#
# This could be made into a standard header
#
proc app_body_start {} {
	global size2 ef
	global TclConf
	global TclWhere
	global WhichLogo

	if {![info exists WhichLogo]} {
		set WhichLogo ProgComm
	}

	hr
    cgi_table {
	cgi_table_row { td [cgi_imglink TclMarble]; td "$size2 [cgi_title] <br> $TclConf <br> $TclWhere $ef<br>" }
	cgi_table_row { td colspan=2 [cgi_imglink $WhichLogo] }
    }
     	hr
}

proc app_body_end {} {

	global WhichLogo

	if {$WhichLogo == "Admin"} {
		set start "AdStart"
	} else {
		set start "Start"
	}
#    puts "[cgi_link Start]"
	hr
    p "<center>"
    cgi_table {
	cgi_table_row { td "[cgi_link $start]<br>to the top"; td "   ";td "These pages were created using CGI-Tcl.<br>They are based on the Tcl98 program committee pages by Michael McLennan.";td "[cgi_imglink Feather]"}
    }
   p "</center>"
    hr; puts "Please report any problems with this script to [cgi_link admin]."
    br; puts "Authors: Michael McLennan (1998) De Clarke (1999)"
}

# Generic appearance attributes
#
# cgi_body_args bgcolor=ivory text=black link=blue vlink=purple background=$tclpcBackGnd
# I just can't get the damn gif or jpg to be pale enough.
cgi_body_args bgcolor=ivory text=black link=blue vlink=purple 
#
# some useful looky-feely stuff
#
set SansSerif "Lucida,Helvetica,Arial"
set Courier "Courier,Typewriter"
set HighLight "#444444"
set size2 "<font size=\"+2\">"
set ss0 "<font face=\"$SansSerif\" color=black>"
set ss1 "<font face=\"$SansSerif\" size=\"+1\" color=black>"
set cou0 "<font face=\"$Courier\" color=black>"
set ef "</font>"
#
# permit list and deny list for display.cgi
# Display OK is checked first, then DisplayNOT negates if needed
#
set DisplayOK "/dsk/www/de/Tcl /dsk/www/de/humour /dsk/a/httpd/cgi-bin/Doc /dsk/a/httpd/cgi-bin/Tcl" 
set DisplayNOT ""
#
#
# Global variables for this year:  these strings get used a lot.
#
set TclChairs "De Clarke and Tom Poindexter -- tclchairs@usenix.org"
set TclConf "7th Annual Usenix Tcl/Tk Conference"
set TclNick "Tcl/2K"
set TclWhere "Austin, TX"
set TclWhen "Feb 14-18 2000"
set WebMaster "de@ucolick.org"
set ReviewsTo "tcl2k@ucolick.org"
set MainPage "$Tcl2K/index.cgi"
set ReviewDeadline "October 1, 1999"
set pcPage "http://www.ucolick.org/cgi-bin/Tcl2K/index.cgi"
#
# these aren't necessarily identical, as you see...
#
# You MUST set Testing to 0 when you are finished testing this code.
# If Testing is set to 1, several essential features will be disabled.
set Testing 0
#
set BASE "$Tcl2K"
set CGIBASE $BASE
set BASEDIR /lopt/apache/cgi-bin/Tcl2K
#
set HTMLURL http://www.ucolick.org/~de/Tcl2K
set HTMLDIR /lopt/apache/u/de/Tcl2K
set HTMLPATH ~de/Tcl2K
set reviewsDir reviews
set submissDir submissions
#
set DataFile data/tclPapers.dat
#
