#!/opt/tcl803/bin/tcl

# first, get the goodies you need
#
source cgi.tcl
package require Tclgdbm
#
# this should start a safe interp
#
source tclPaperslib.tcl
#
cgi_eval {

    source common.tcl

    cgi_title "$TclNick Program Committee Admin:  Delete a Review"

    # use targets if we are framed
    if {0==[catch {cgi_import framed}]} {
        set target "target=script"
    } else {
        set target ""
    }

    proc script {name} {
        global target
        cgi_url "$name.cgi" [cgi_cgi $name] $target
    }

    cgi_body {

        cgi_form DoReview {

		cgi_table border=0 cellpadding=4 cellspacing=0 {

                cgi_table_row {

                cgi_table_data { cgi_imglink Blank}
        
                cgi_table_data valign="top" width="100%" {

		cgi_table border=0 cellpadding=0 cellspacing=8 bgcolor=lemonchiffon {

		cgi_table_row {
			td "Pick a reviewer, pick a paper, and hit Delete to delete that review.  Better be sure you really mean it though."
		}

                cgi_table_row {

			cgi_table_data {
				cgi_select name {
					foreach name [lsort [TP_program_committee]] {
					cgi_option $name
					}
		
				}
			}
		}

		cgi_table_row {

			cgi_table_data {
				cgi_select title {
					foreach paper [lsort [TP_submission_all]] {
					set t [TP_submission $paper title]
					cgi_option $t
					}
				}
			}
		}

#
		cgi_table_row {
			cgi_table_data {
				cgi_submit_button action=Delete
			}
		}

		}



		}
		}
		}
#		END TABLE
	}
#	END FORM
                
    }

}

