#!/opt/tcl/bin/tcl

# This is a CGI script that displays another CGI script
# and massages "source" commands into hyperlinks

source cgi.tcl

cgi_eval {
    source common.tcl

    cgi_input

    cgi_head {

	set scriptname [info script]; # display self by default!
	catch {cgi_import scriptname}
	set nickname [file tail $scriptname]

#	if you can't find the file locally (nickname) then check if it's executable.
#	if it's executable, forget it.  bad kid, no dessert.

	set OK 0
	foreach d $DisplayOK {
		if {[string first $d $scriptname] >= 0} {
			set OK 1
			break
		}
	}
	foreach d $DisplayNOT {
		if {[string first $d $scriptname] >= 0} {
			set OK 0
			break
		}
	}
	if {!$OK} {
		h1 "So Sorry"
		p "It seems you are not permitted to read source for <b>$scriptname</b>"
		p "If you believe this denial of access is erroneous, write to
		   [cgi_link Webmaster]"
		exit 0
	}
	cgi_title "Source for $nickname"
    }
    cgi_body {
	# Prevent people from opening directories!
	switch $scriptname . - .. - "" {
	    h3 "Illegal filename: $scriptname"
	    return
	}
	if [catch {set fid [open $scriptname]}] {
	    h3 "No such file: $scriptname"
	    return
	}
	cgi_preformatted {
	    while {-1 != [gets $fid buf]} {
		if [regexp "^(\[ \t]*)source (.*)" $buf ignore space filename] {
		    puts "[set space]source [cgi_url $filename [cgi_cgi display scriptname=$filename]]"
		} else {
		    puts [cgi_quote_html $buf]
		}
	    }
	}
    }
}

