#!/opt/tcl803/bin/tcl

# first, get the goodies you need
#
source cgi.tcl
source common.tcl
package require Tclgdbm
#
# this should start a safe interp
#
source tclPaperslib.tcl
set WhichLogo Admin
#
cgi_eval {

    source common.tcl

    cgi_title "$TclNick : Review Assignments"

    # use targets if we are framed
    if {0==[catch {cgi_import framed}]} {
        set target "target=script"
    } else {
        set target ""
    }

    proc script {name} {
        global target
        cgi_url "$name.cgi" [cgi_cgi $name] $target
    }

    cgi_body {


        cgi_table border=0 cellpadding=4 cellspacing=0 {

                cgi_table_row {

                cgi_table_data { cgi_imglink Blank}
        
                cgi_table_data valign="top" width="100%" {

		p "This page shows the review assignments for the Program Committee for $TclNick.  You should download the submissions that have been assigned to you, and after evaluating them, use the [cgi_link Review] page to submit your reviews."
		p "<b>NOTE</b> Your reviews must be submitted by $ReviewDeadline"
                cgi_table border=0 cellpadding=0 cellspacing=8 bgcolor=lemonchiffon {

		foreach name [lsort [TP_program_committee]] {
			cgi_table_row {td colspan=3 [cgi_bold [string toupper $name]]}
		    foreach paper [TP_program_committee $name review] {
			cgi_table_row {
			cgi_table_data align=right valign=top {
				if {[TP_reviewed $paper $name]} {
					cgi_imglink Check
				} else {
					cgi_imglink Bullet
				}
			}
			td colspan=2 "[TP_submission $paper title]<br> <font size=-1>by [TP_submission $paper authors]</font>"
		        }
		        cgi_table_row {
				td ""
				cgi_table_data align=right {
				p "<font size=-1><b>DOWNLOAD</b></font>"
				}
				cgi_table_data {
				set file $HTMLURL/[TP_submission $paper html]
				if {$file != ""} {
				p "<a href=$file>HTML/text</a>"
#				p "HTMLPATH $HTMLPATH"
#				p "html [TP_submission $paper html]"
#				p "file $file"
				}
				set file $HTMLURL/[TP_submission $paper postscript]
				if {$file != ""} {
				p "<a href=$file>Postscript/PDF</a>"
#				p "HTMLPATH $HTMLPATH"
#				p "html [TP_submission $paper html]"
#				p "file $file"
				}
				}
			}
					
			}	
		}

		}

		}

		}

	}

	}

}
		
