#!/opt/tcl803/bin/tcl

# first, get the goodies you need
#
source cgi.tcl
package require Tclgdbm
#
# this should start a safe interp
#
source tclPaperslib.tcl
#
cgi_eval {

    source common.tcl

	cgi_input
	cgi_import which

    cgi_title "$TclNick $which submissions"

    # use targets if we are framed
    if {0==[catch {cgi_import framed}]} {
        set target "target=script"
    } else {
        set target ""
    }

    proc script {name} {
        global target
        cgi_url "$name.cgi" [cgi_cgi $name] $target
    }

    cgi_body {

	cgi_table  border=1 cellpadding=4 cellspacing=0 {
		cgi_table_row {td {}; td SCORE; td SUBMISSION; td STATUS}
		set counter 0
		foreach paper [TP_submission_all $which byscore] {
#		ROW 1
		cgi_table_row {td [incr counter]; td [TP_submission $paper score]; td [cgi_bold [TP_submission $paper title]]
			set status [TP_submission $paper status]
			if {"" != $status} {
				td $status
			}
		}
#		ROW 2
		cgi_table_row {
		td {}
		td {}
		set email [TP_submission $paper email]
		set text "By "
		if {"" != $email} {
			append text "<a href=\"mailto:$email\">[TP_submission $paper authors]"
		} else {
			append text [TP_submission $paper authors]
		}
		td "$text"
		}
#		ROW 3
		cgi_table_row {
		td {}
		td {}
		cgi_table_data {
#		embedded table
		cgi_table {
#		Row B1
		cgi_table_row {
		cgi_table_data {
			puts "DOWNLOAD"
		}
		set file [TP_submission $paper cover]
		cgi_table_data {
		if {"" != $file} {
			puts "&nbsp;&nbsp;<a href=\"$HTMLURL/$file\">Cover letter</a>"
		}
		set file [TP_submission $paper postscript]
		if {"" != $file} {
			puts "&nbsp;&nbsp;<a href=\"$HTMLURL/$file\">PostScript/PDF</a>"
		}
		set file [TP_submission $paper html]
		if {"" != $file} {
			puts "&nbsp;&nbsp;<a href=\"$HTMLURL/$file\">HTML/text</a>"
		}
		}
		}
#		END B1
#		Row B2
		cgi_table_row {
			td REVIEWS:
			cgi_table_data {
				foreach rev [TP_review_all $paper] {
				set revname [TP_review $rev reviewer]
				set revhtml [TP_review $rev html]
				set revscore [TP_review $rev score]
				puts "&nbsp;&nbsp;<a href=\"$HTMLURL/$revhtml\">$revname</a> ($revscore)<br>"
				}
				foreach revname [TP_reviews_outstanding $paper] {
					puts "&nbsp;&nbsp;$revname<br>"
				}
			}
		}
		}
#		END embedded table
		}
		}
#		END ROW 3
		}
	} 
#	END MAIN TABLE
    }
#   END CGI BODY


}
# END CGI EVAL
