#!/opt/tcl803/bin/tcl

# first, get the goodies you need
#
source cgi.tcl
package require Tclgdbm
#
# this should start a safe interp
#
source tclPaperslib.tcl
#
set vlist [list title authors email cover postscript html postscript2 html2 status]
array set varlabels {
	title Title
	authors AUthors
	email E-Mail
	cover "Cover Letter"
	postscript "Postscript/PDF"
	html "HTML/Text"
	postscript2 "Poster Draft (ps)"
	html2 "Poster Draft (html)"
	status Status
}
set file(cover) 1
set file(postscript) 1
set file(postscript2) 1
set file(html) 1
set file(html2) 1
#
set WhichLogo Admin
#
cgi_eval {

    source common.tcl

    cgi_title "$TclNick Administration:  Submissions"

    # use targets if we are framed
    if {0==[catch {cgi_import framed}]} {
        set target "target=script"
    } else {
        set target ""
    }

    proc script {name} {
        global target
        cgi_url "$name.cgi" [cgi_cgi $name] $target
    }

    cgi_body {


        cgi_table border=0 cellpadding=4 cellspacing=0 {

                cgi_table_row {

                cgi_table_data { cgi_imglink Blank}
        
                cgi_table_data valign="top" width="100%" {

#               p "[cgi_imglink ProgComm.gif]"

                cgi_br 


                cgi_table border=0 cellpadding=0 cellspacing=8 bgcolor=antiquewhite {

		cgi_form DoSubmit enctype=multipart/form-data {

		cgi_table_row {
			cgi_table_data colspan=2 {
				h2 "Add Submission"
			}
		}

#		FIRST ROW:  select type
		cgi_table_row {
			td "$ss0 Type $ef"
			cgi_table_data {
				cgi_select type {
					foreach i {paper panel demonstration poster} {
						cgi_option $i
					}
				}
			}
		}
#		END ROW 1

		foreach v $vlist {
		cgi_table_row {
		td "$ss0 $varlabels($v) $ef"
		cgi_table_data {
			if {[info exists file($v)]} {
#			cgi_text ${v}= size=30 type=file
			cgi_file_button $v
#			p "Made cgi_file_button for $v"
			} else {
			cgi_text ${v}= size=40 
#			p "Made cgi_text box $v type is plain"
			}
		}
		}
		}
#	END of INPUT ROWS

		cgi_table_row {
		cgi_table_data colspan=2 {
			cgi_submit_button action=Add
		}
		}

    		}
#		END FORM A
	
#		START FORM B
		cgi_form DoSubmit {
			cgi_export prompt=1
			cgi_table_row {
				cgi_table_data colspan=2 {
				h2 "Modify/Delete Submission"
				}
			}
			cgi_table_row {
				td "$ss0 Title $ef"
				cgi_table_data {
				cgi_select title size=5 {
					foreach t [TP_submission_all] {
					set tt [TP_submission $t title]
					cgi_option $tt
					}
				}
				}
			}
			cgi_table_row {
				cgi_table_data {
				cgi_submit_button action=Modify
				}
				cgi_table_data {
				cgi_submit_button action=Delete
				}
			}

		}
#		END of FORM B

		}
#		END OF INNER TABLE

		}
#		END OF CELL

		}
#		END OF ROW
	}
#	END OUTER TABLE

    }
#   END BODY

}
# END EVAL
