# ----------------------------------------------------------------------
# PURPOSE:
#   Library routines common to all tclPapers-* scripts in this directory.
# ----------------------------------------------------------------------

proc TP_return_page {script {title {Result Page}}} {
    global BASE

    cgi_head {
        cgi_title "$title"
#        cgi_put [eval $heading]
    }
    cgi_body bgcolor=ivory text=black link=red vlink=purple \
        background=$BASE/images/backgr.gif {

        cgi_table border=0 cellpadding=0 cellspacing=0 {
          cgi_table_row {
            td "[cgi_imglink Blank]"
	    cgi_table_data valign=top {
#              cgi_put "[cgi_imglink Admin]"
#              cgi_br
              uplevel #0 $script
            }
          }
        }
    }
}

proc TP_return_error {mesg} {
    TP_return_page [format {
        cgi_table border=0 cellpadding=0 cellspacing=0 {
          cgi_table_row {
            cgi_table_data {
                cgi_put [cgi_img $BASE/images/error.gif border=0 alt=ERROR!]
            }
            cgi_table_data {
                cgi_put [cgi_strong %s]
                cgi_br
                cgi_put {Please back up and try again.}
            }
          }
        }
    } [list $mesg]] ERROR
}

# ----------------------------------------------------------------------
# USAGE: TP_submission_find <title>
#
# Searches for a submission with the specified <title>.  Returns a
# token representing the submission, or "" if not found.
# ----------------------------------------------------------------------
proc TP_submission_find {title} {
	global DataFile
    set db [gdbm open $DataFile rwc]
	set all ""
    catch {set all [gdbm fetch $db "submissions"]}
    set found 0
    foreach token $all {
	set t ""
        catch {set t [gdbm fetch $db "$token-title"]}
        if {[string compare $t $title] == 0} {
            set found 1
            break
        }
	regsub -all "  " $t " " t
	if {[string compare $t $title] == 0} {
            set found 1
            break
        }
    }
    gdbm close $db

    if {$found} {
        return $token
    }
    return ""
}

# ----------------------------------------------------------------------
# USAGE: TP_reviewer_add <token> <name>
#
# Adds the reviewer <name> to the list of reviewers for the submission
# represented by <token>.
# ----------------------------------------------------------------------
proc TP_reviewer_add {token name} {
	global DataFile
    set db [gdbm open $DataFile rwc]

	set all ""
    catch {set all [gdbm fetch $db "pc-$name-review"]}
    set i [lsearch $all $token]
    if {$i < 0} {
        lappend all $token
    }
    gdbm store $db "pc-$name-review" $all

	set all ""
    catch {set all [gdbm fetch $db "$token-reviewers"]}
    set i [lsearch $all $name]
    if {$i < 0} {
        lappend all $name
    }
    gdbm store $db "$token-reviewers" $all

    gdbm close $db
}

# ----------------------------------------------------------------------
# USAGE: TP_reviewer_del <token> <name>
#
# Removes the reviewer <name> from the list of reviewers for the
# submission represented by <token>.
# ----------------------------------------------------------------------
proc TP_reviewer_del {token name} {
	global DataFile
    set db [gdbm open $DataFile rwc]

	set all ""
    catch {set all [gdbm fetch $db "pc-$name-review"]}
    set i [lsearch $all $token]
    if {$i >= 0} {
        set all [lreplace $all $i $i]
    }
    gdbm store $db "pc-$name-review" $all

	set all ""
    catch {set all [gdbm fetch $db "$token-reviewers"]}
    set i [lsearch $all $name]
    if {$i >= 0} {
        set all [lreplace $all $i $i]
    }
    gdbm store $db "$token-reviewers" $all

    gdbm close $db
}

# ----------------------------------------------------------------------
# USAGE: TP_review_del <token> <name>
#
# Deletes a review from reviewer <name> for the submission represented
# by <token>.
# ----------------------------------------------------------------------
proc TP_review_del {token name} {
	global DataFile ofp

    set db [gdbm open $DataFile rwc]

#    puts $ofp "DELETE REVIEW for $token by $name"

    set found ""
	set revs ""
	catch {set revs [gdbm fetch $db "$token-reviews"]}

#    puts $ofp "FOUND REVIEWS $revs for $token"

    foreach rev $revs {
        set revname [gdbm fetch $db "$rev-reviewer"]
#        puts $ofp "      One reviewer was $revname, is that $name?"
        if {$name == $revname} {
#	    puts $ofp "      YES reviewer $name did review $token : $rev"
	    lappend found $rev
        }
    }

    if {$found == ""} {
#	puts $ofp "NO REVIEWS for $token by $name"
        error "no review(s) for $token by $name"
    }

    foreach rev $found {

	set file ""
    catch {set file [gdbm fetch $db "$rev-html"]}
#	puts $ofp "Found review $rev, delete file $file"
    if {[file exists $file]} {
        file delete -force $file
    }

	set all ""
    catch {set all [gdbm fetch $db "$token-reviews"]}
    set i [lsearch $all $rev]
    if {$i >= 0} {
        set all [lreplace $all $i $i]
    }

    gdbm store $db "$token-reviews" $all

    gdbm delete $db "$rev-title"
    gdbm delete $db "$rev-reviewer"
    gdbm delete $db "$rev-score"
    gdbm delete $db "$rev-multiplier"
    gdbm delete $db "$rev-strengths"
    gdbm delete $db "$rev-weaknesses"
    gdbm delete $db "$rev-bottomline"
    gdbm delete $db "$rev-comments"
    gdbm delete $db "$rev-private"
    gdbm delete $db "$rev-html"

    set total 0
    set mtotal 0
    foreach rev $all {
	set sval ""
        catch {set sval [gdbm fetch $db "$rev-score"]}
	set mval ""
        catch {set mval [gdbm fetch $db "$rev-multiplier"]}
        if {"" != $sval} {
            set total [expr $total + $sval*$mval]
            set mtotal [expr $mtotal + $mval]
        }
    }
    if {$mtotal == 0} {
        set avg ""
    } else {
        set avg [format "%.2f" [expr double($total)/$mtotal]]
    }
    gdbm store $db "$token-score" $avg

    }
    gdbm close $db
}

# ----------------------------------------------------------------------
# USAGE: TP_regenerate <dir> <dir>...
#
# Regenerates HTML files in the specified directories.  This procedure
# looks for files named *.html.in in each directory, and then processes
# the files, evaluating any Tcl scripts within them.  The resulting
# files are saved as *.html files in the same directory.
# ----------------------------------------------------------------------
proc TP_regenerate {args} {
	global DataFile
    catch {file copy -force $DataFile data/tcltkPapers.bak}

    foreach dir $args {
        foreach file [glob -nocomplain [file join $dir *.html.in]] {
            set fid [open $file "r"]
            set page [read $fid]
            close $fid

            set page [TP_process_page $page]

            set fid [open [file rootname $file] "w"]
            puts $fid $page
            close $fid
        }
    }
}

# ----------------------------------------------------------------------
# USAGE: TP_process_page <page>
#
# Takes an HTML <page> as input, and searches for regions marked
# with "@TCLSCRIPT@ ... @@".  The code within these markings is
# executed, and any resulting HTML is substituted in its place.
# The final page (with all substitutions) is returned as the
# result of this procedure.
# ----------------------------------------------------------------------
proc TP_process_page {page} {
    global tclPapershtml
    while {[regexp {(.*)@TCLSCRIPT@(.+)@@(.*)} $page dmy first script last]} {
        set tclPapershtml(buffer) ""
        $tclPapershtml(parser) eval $script
        set page [concat $first $tclPapershtml(buffer) $last]
    }
    return $page
}

# set tclPapershtml(parser) [interp create -safe]
# $tclPapershtml(parser) alias html TP_html
# $tclPapershtml(parser) alias program_committee TP_program_committee
# $tclPapershtml(parser) alias submission_all TP_submission_all
# $tclPapershtml(parser) alias submission TP_submission
# $tclPapershtml(parser) alias review_all TP_review_all
# $tclPapershtml(parser) alias review TP_review
# $tclPapershtml(parser) alias reviewed TP_reviewed
# $tclPapershtml(parser) alias reviews_outstanding TP_reviews_outstanding

proc TP_html {str} {
    global tclPapershtml
    append tclPapershtml(buffer) $str "\n"
}

proc TP_program_committee {{name ""} {attr ""}} {
	global DataFile
    set db [gdbm open $DataFile r]
	set all ""
    catch {set all [gdbm fetch $db "program-committee"]}

    if {"" == $name} {
        return $all
    }
    if {[lsearch $all $name] < 0} {
        error "name \"$name\" not on program committee"
    }
	set val ""
    catch {set val [gdbm fetch $db "pc-$name-$attr"]}
    gdbm close $db

    return $val
}

proc TP_submission_all {{type ""} {sort "bytitle"}} {
	global DataFile
    if {$type == ""} {
        set type "submissions"
    }
    set db [gdbm open $DataFile r]
	set all ""
    catch {set all [gdbm fetch $db $type]}
    catch {set all [lsort -command "TP_sort_$sort $db" $all]}
    gdbm close $db
    return $all
}

proc TP_submission {token attr} {
	global DataFile
    set db [gdbm open $DataFile r]
	set val ""
    catch {set val [gdbm fetch $db $token-$attr]}
    gdbm close $db
    return $val
}

proc TP_sort_bytitle {db token1 token2} {
    set title1 [gdbm fetch $db $token1-title]
    set title2 [gdbm fetch $db $token2-title]
    return [string compare $title1 $title2]
}

proc TP_sort_byscore {db token1 token2} {
    set score1 [gdbm fetch $db $token1-score]
    set score2 [gdbm fetch $db $token2-score]
    if {$score1 == $score2} {
        set title1 [gdbm fetch $db $token1-title]
        set title2 [gdbm fetch $db $token2-title]
        return [string compare $title1 $title2]
    }
    if {$score1 == ""} {
        return 1
    }
    if {$score2 == ""} {
        return -1
    }
    if {$score1 > $score2} {
        return -1  ;# high scores on top
    }
    return 1
}

proc TP_review_all {paper} {
	global DataFile
    set db [gdbm open $DataFile r]
    set all [gdbm fetch $db $paper-reviews]
    set all [lsort -command "TP_sort_byreviewer $db" $all]
    gdbm close $db
    return $all
}

proc TP_sort_byreviewer {db token1 token2} {
    set name1 [gdbm fetch $db $token1-reviewer]
    set name2 [gdbm fetch $db $token2-reviewer]
    return [string compare $name1 $name2]
}

proc TP_review {token attr} {
	global DataFile
    set db [gdbm open $DataFile r]
    set val [gdbm fetch $db "$token-$attr"]
    gdbm close $db
    return $val
}

proc TP_reviewed {token name} {
	global DataFile
    set db [gdbm open $DataFile r]
    set found 0
    foreach rev [gdbm fetch $db "$token-reviews"] {
        set revname [gdbm fetch $db "$rev-reviewer"]
        if {$revname == $name} {
            set found 1
            break
        }
    }
    gdbm close $db
    return $found
}

proc TP_reviews_outstanding {token} {
	global DataFile
    set db [gdbm open $DataFile r]
    set all ""
    foreach revname [gdbm fetch $db "$token-reviewers"] {
        set found 0
        foreach rev [gdbm fetch $db "$token-reviews"] {
            set name [gdbm fetch $db "$rev-reviewer"]
            if {$name == $revname} {
                set found 1
                break
            }
        }

        if {!$found} {
            lappend all $revname
        }
    }
    gdbm close $db
    return $all
}
#
# recent procs
#
proc show_wips_list {} {

        global DataFile

    set db [gdbm open $DataFile r]
        set all ""
    catch {set all [gdbm fetch $db "wips"]}
        cgi_definition_list {
        foreach a $all {
                set wt [gdbm fetch $db $a-title]
                set wn [gdbm fetch $db $a-speaker]
                set wo [gdbm fetch $db $a-overview]
                set wa [gdbm fetch $db $a-affiliation]
                set we [gdbm fetch $db $a-email]
                set ws [gdbm fetch $db $a-time]
                cgi_term "[cgi_bold "$wt"] by $wn from $wa ($we)"
                cgi_term_definition "Slot $ws<br><i>$wo</i>"
        }
        }
    gdbm close $db
    return $all

}
#
proc show_demo_list {} {

        global DataFile

    set db [gdbm open $DataFile r]
        set all ""
    catch {set all [gdbm fetch $db "demos"]}
        cgi_definition_list {
        foreach a $all {
                set dt [gdbm fetch $db $a-title]
                set dn [gdbm fetch $db $a-speaker]
                set do [gdbm fetch $db $a-overview]
                set da [gdbm fetch $db $a-affiliation]
                set de [gdbm fetch $db $a-email]
                cgi_term "[cgi_bold "$dt"] by $dn from $da ($de)"
                cgi_term_definition "<i>$do</i>"
        }
        }
    gdbm close $db
    return $all

}

