#!/bin/sh
#\
exec /opt/tcl803/bin/tclsh "$0"
# ----------------------------------------------------------------------
#  PURPOSE: Processes incoming mail messages to receive reviews
#    for papers, panels, demos and posters.  Registers each review
#    in the database and sends e-mail to the reviewer.
# ----------------------------------------------------------------------
#
proc forward {addr subject explain mesg} {
    set fid [open "| /usr/lib/sendmail -oi -t" "w"]
    puts $fid "To: $addr"
    puts $fid "From: tcl2k <tcl2k@ucolick.org>"
    puts $fid "Subject: $subject"
    puts $fid "Date: [clock format [clock seconds]]"
    puts $fid ""  ;# sendmail terminates header with blank line
    puts $fid $explain
    puts $fid ""
    puts $fid "--> $TclChairs"
    puts $fid "--> $TclConf"
    puts $fid "------------------------------------------------------------"
    foreach line [split $mesg "\n"] {
        puts $fid "> $line"
    }
    close $fid
}

#
# Read the message from stdin and see if it looks like a review.
# If not, forward elsewhere for consideration.
#
set mesg [read stdin]
if {![regexp "REVIEWER:.+TITLE:.+SCORE:.+MULTIPLIER" $mesg] &&
    ![regexp "REVIEWER:.+TITLE:.+SCORE:.+WEIGHT" $mesg]} {
    catch {
        forward $WebMaster "please follow up" \
            "The following message was received by tclPaperspc, but it
doesn't match the review format for the program committee.
Please follow up with the sender." $mesg
    }
}

set time [clock seconds]

set fn /usr/local/www/de/Tcl2K/incoming/Incoming.$time

set err [catch {set ofp [open $fn w] } res]
if {$err} {
		puts stderr "OUCH could not open file"
		puts stderr "     $fn"
		puts stderr " $res"
		exit 1
}

puts $ofp "$mesg"

close $ofp

# MV this file to the "complete" location which the cron job will
# see

exec mv $fn /usr/local/www/de/Tcl2K/rcv

# no, that won't work
# exec /usr/local/bin/scp $fn osiris:/u/de/Tcl2K/rcv

# that won't work either
# exec chown de $fn

