#!/opt/tcl/bin/sytcl
#!/opt/tcl/bin/tcl
#
#-------------------------------------------------------------------------
# initialize interp
#-------------------------------------------------------------------------
# first build your interp with all necessary extensions.
# always start with a sybtcl/tclX equipped wish!
#
global env
set tcllib /opt/tcl/lib
set tclroot /opt/share/tcl
set ucodb $tclroot/lib/ucodb
#
set myname [file tail $argv0]
loadlibindex $ucodb/ucodb.tlib
if {$myname == "task"} {
loadlibindex $ucodb/task.tlib
} else {
loadlibindex ./task.tlib
}
#
set Version 0.0
set cvs(Id) {$Id: task,v 1.4 1999/07/26 18:16:39 de Exp $}
set cvs(Revision) {$Revision: 1.4 $}
scan $cvs(Revision) "%*s %s" Version
puts stderr "Version $Version"
#
#-------------------------------------------------------------------------
# initialize globals
#-------------------------------------------------------------------------
#
#
set GUI 0
set Find 0
set Username [id user]
#
global sybmsg
set uname ktl
set base keck
set server UCO-SCIDB
set pass NOYB
# 
set err [catch {set dbpipe1 [sybOpen $base $uname $pass $server]} res]
if {!$err} {
set dbpipe2 [sybOpen $base $uname $pass $server]
} else {
	puts stderr "NO SYBASE CONNECTION $res"
}
#
set tsktbl keck.dbo.Tasks
set histbl keck.dbo.TaskMorgue
set agntbl keck.dbo.Agents
set grptbl keck.dbo.TaskGroup
#
set DelNotify $ucodb/help/TaskDelNotify
#
set LogFile /opt/share/tcl/log/Task.log
#
set LegitCmds "add hours status list show report"
setGlobals
#
set syntax "\nUsage:\t\ttask Command ?TaskName? ?OtherArgs?\n\nExamples:\ttask list ?UserName?\n\t\ttask show MyTask\n\t\ttask hours My myTask 2.5\n\t\ttask status MyTask onhold\n\t\ttask add NewTask\n\t\ttask summary ?UserName?\n\t\ttask report ?UserName?"
#
if {[llength $argv] == 0} {
	puts stderr "$syntax"
	exit 0
}
set arg1 [lvarpop argv]
if {[lsearch $LegitCmds $arg1] < 0} {
	puts stderr "$syntax"
	exit 0
}
#
case $arg1 in {
	{list} {
		set arg2 [lvarpop argv]
		if {$arg2 != ""} {
			set Username $arg2
		}
	}
	{report} {
		if {$argv == ""} {
			set argv "\{user $Username\}"
		}
	}
	{default} {
		set Task [lvarpop argv]
		if {$Task == ""} {
			puts stderr "$syntax"
			puts stderr "\nNeed a Task Name."
			exit 0
		}
	}
}
#
set args ""
catch {eval lvarcat args $argv}
# puts stderr "CALL ${arg1}Task $args"
set cmd ${arg1}Task
#
eval $cmd $args
#
