#!/opt/tcl/bin/sywish
#!/opt/tcl/bin/wishx
#
#-------------------------------------------------------------------------
# initialize interp
#-------------------------------------------------------------------------
# first build your interp with all necessary extensions.
# always start with a sybtcl/tclX equipped wish!
#
global env
set tcllib /opt/tcl/lib
set tclroot /opt/share/tcl
set ucodb $tclroot/lib/ucodb
set bitmapdir $ucodb/bitmaps
#
# load the BLT shareable lib if you have it!  if not, continue anyway.
#
set GUI 1
set Plot 1
set bltver [package require BLT]
# set err [catch {load $tcllib/libBLT.so.2} res]
if {$bltver == ""} {
        puts stderr "No BLT library or error loading:"
        puts stderr "That means no Plots."
        set Plot 0
} 
namespace import blt::*
#
# use the tkmail bindings, with whatever hacks we add locally
# if the enhanced bindxtnd.tcl is not the default, source it
#
        if {[info proc tkBindDefVar]==""} {
          foreach key [bind Text] { bind Text $key {} }
          foreach key [bind Entry] { bind Entry $key {} }
          source $ucodb/tkbind/bindxtnd.tcl
          source $ucodb/tkbind/text.tcl
          source $ucodb/tkbind/entry.tcl
          # source additional packages here
        }
#
loadlibindex $ucodb/ucodb.tlib
if {$argv == ""} {
loadlibindex $ucodb/task.tlib
} else {
loadlibindex ./task.tlib
}
#
puts stderr "Loaded all libs, ready to roll."
#
set helpdir $tclroot/lib/ucodb/help
# set helpdir /u/de/cvs/tcldb/memes/etcha/help
#
#
set Version 0.0
set cvs(Id) {$Id: xtask,v 1.8 1998/03/05 01:53:41 de Exp $}
set cvs(Revision) {$Revision: 1.8 $}
scan $cvs(Revision) "%*s %s" Version
puts stderr "Version $Version"
#
#-------------------------------------------------------------------------
# initialize globals
#-------------------------------------------------------------------------
#
#
set Username [id user]
#
global env
global sybmsg
set uname ktlw
set base metabase
set server YAKUZA
set pass NOYB
# 
set err [catch {set dbpipe1 [sybOpen $base $uname $pass $server]} res]
if {!$err} {
set dbpipe2 [sybOpen $base $uname $pass $server]
} else {
	puts stderr "NO SYBASE CONNECTION $res"
}
#
set tsktbl omnibus.dbo.Tasks
set histbl omnibus.dbo.TaskMorgue
set agntbl omnibus.dbo.Agents
set grptbl omnibus.dbo.TaskGroup
#
set DelNotify $ucodb/help/TaskDelNotify
#
# Message area background colour rotates among this list, so as
# to attract your attention when the message changes
set MsgColours(0) linen
set MsgColours(1) honeydew
set MsgColours(2) papayawhip
set MsgColours(3) azure
set MsgColours(4) lemonchiffon
set MsgColours(5) lavender
set MsgColours(6) bisque
set MsgColours(7) mistyrose
#
set PlotCt 0
#
set PlotColours(0) blue
set PlotColours(1) yellow
set PlotColours(2) green
set PlotColours(3) orange
set PlotColours(4) cyan
set PlotColours(5) red
set PlotColours(6) turquoise
set PlotColours(7) purple
set PlotColours(8) pink
set PlotColours(9) gray
#
# Plot background colour, calendar annotation colour, calendar gridline colour
#
set PlotBack gray60
set CalenColour gray80
set GridColour white
#
# marker colour for NOW and end pt - slip markers
# alarm colour for conflict boxes and bad depends
# depend colour for normal dependencies
#
set MarkerColour cyan
set NastyColour red
set DependColour yellow
#
set Multi 0
set Find 0
set Start [clock seconds]
set FStart [clock format $Start]
#
set LogFile /opt/share/tcl/log/Task.log
set debug task.log
set lfp [open $debug w]
# set tfp [open etcha.trace w]
# cmdtrace on $tfp
#
puts $lfp "\n\n\n***-------------------------------------------------------------***"
puts $lfp "XTASK LOG START [clock format [clock seconds]] ... "
puts $lfp "***-------------------------------------------------------------***\n\n"
#
#-------------------------------------------------------------------------
# initialize main window and go
#-------------------------------------------------------------------------
#
#
setGlobals
#
set home /u/[id user]
catch {set home $env(HOME)}
if {[file exists $home/.xtask]} {
	puts stderr "Sourcing user's .xtask file..."
	source $home/.xtask
}
#
mkTask
#
mkMsg "Ready ..."
#
