include <imhdr.h>

#
# T_ANKERN: Calculates the fraction of flux within various boxes
# Note that "moments info does not work.
# Written by A.C.Phillips at UW; last modified Jul 94 at Lick Obs.
# 

procedure t_ankern()

char	image[SZ_FNAME]
int	nx, ny, i, nring
int	xc, x1, x2, yc, y1, y2
real	sum, zrms, zmax, zmin, xmom, ymom
pointer	im, ip

int	clgeti()
real	sums2r()
pointer	immap(), imgs2r()

begin
	call clgstr ("image", image, SZ_FNAME)
	im = immap (image, READ_ONLY, 0)
	nx = IM_LEN(im,1)
	ny = IM_LEN(im,2)

	nring = clgeti ("rings")
	nring = min ( (min (nx, ny) / 2 - 1), nring)

	xc = nx / 2 + 1
	yc = ny / 2 + 1

	ip = imgs2r (im, 1, nx, 1, ny)

	sum = sums2r (Memr[ip], nx, ny, 1, nx, 1, ny)
	call adivkr (Memr[ip], sum, Memr[ip], (nx * ny))

	call printf (
	"\nSection \tFraction\t rms \t max  \t min   \t xmom  \t ymom\n")

	do i = 0, nring {
		x1 = xc - i
		x2 = xc + i
		y1 = yc - i
		y2 = yc + i
		call stats (Memr[ip], nx, ny, x1, x2, y1, y2,
					sum, zrms, zmax, zmin, xmom, ymom)
		call printf (
		"[%d:%d,%d:%d]\t%6.4f  \t%6.4f\t%6.4f\t%7.4f\t%6.3f\t%6.3f\n")
			call pargi (x1)
			call pargi (x2)
			call pargi (y1)
			call pargi (y2)
			call pargr (sum)
			call pargr (zrms)
			call pargr (zmax)
			call pargr (zmin)
			call pargr (xmom)
			call pargr (ymom)
	}

	call imunmap (im)
end

#
# SUMS2R: sum 2d real section
#

real procedure sums2r (a, nx, ny, x1, x2, y1, y2)

real	a[nx,ny]
int	nx, ny
int	x1, x2, y1, y2

int	i, j
real	sum

begin
	sum = 0.

	do j = y1, y2
	do i = x1, x2
		sum = sum + a[i,j]
	return (sum)
end
procedure stats (a, nx, ny, x1, x2, y1, y2, zsum, zrms, zmax, zmin, xmom, ymom)

real	a[nx,ny]
int	nx, ny
int	x1, x2, y1, y2
int	npts
real	zsum, zrms, zmax, zmin, xmom, ymom

int	i, j, xc, yc
real	idel, jdel

begin
	xc = nx / 2 + 1
	yc = ny / 2 + 1

	zsum = 0.
	xmom = 0.
	ymom = 0.
	zrms = 0.
	zmax = a[x1,y1]
	zmin = a[x1,y1]
	npts = 0

	do j = y1, y2
	do i = x1, x2 {
		zsum = zsum + a[i,j]
		idel = (i - xc)
		jdel = (j - yc)
# moments not right, because of conv. -- what to do?
		xmom = xmom + a[i,j] * idel
		ymom = ymom + a[i,j] * jdel
		if (i == x1 || i == x2 || j == y1 || j == y2) {
			npts = npts + 1
			zrms = zrms + a[i,j] ** 2
			zmax = max (a[i,j], zmax)
			zmin = min (a[i,j], zmin)
		}
	}
	zrms = sqrt (zrms / npts)
	xmom = xmom / zsum
	ymom = ymom / zsum
end
