include <imhdr.h>
include <math.h>

# T_MKKERN: this task produces a text file from an image, of the form used by
# convolve
# NEW OPTION: apply radial cos**2 filter
# Mod 24/7/92 to break long lines: This should be generalized and extended to
# user-defined formats!
# Written by A.C.Phillips at NOAO and UW; last modified Jul 94 at Lick Obs.

procedure t_mkkern()

char	image[SZ_FNAME]
char	file[SZ_FNAME]
int	fd, nx, ny, i, j, reverse, normalize, filter
real	sum, noisemod
real	r1, r2
pointer	im, ip

real	vsum1(), vsum2()

bool	clgetb()
int	open(), btoi()
real	clgetr()
pointer	immap(), imgs2r()

begin
	call clgstr ("image", image, SZ_FNAME)
	im = immap (image, READ_ONLY, 0)
	nx = IM_LEN(im,1)
	ny = IM_LEN(im,2)

	call clgstr ("file", file, SZ_FNAME)
	fd = open (file, NEW_FILE, TEXT_FILE)

	normalize = btoi (clgetb ("normalize"))
	reverse = btoi (clgetb ("reverse"))
	filter = btoi (clgetb ("filter"))

	ip = imgs2r (im, 1, nx, 1, ny)

	if (filter == YES) {
		r2 = real (nx) / 2.
		r1 = r2 - clgetr ("taper_width")
		call cosfilt (Memr[ip], nx, ny, r1, r2)
	}

	if (normalize == YES)
		sum = vsum1 (Memr[ip], nx*ny)
	else 
		sum = 1.

	noisemod = sqrt (vsum2 (Memr[ip], Memr[ip], nx*ny)) / sum
	call printf ("noise modifier: %7.4f\n")
		call pargr (noisemod)
	call clputr ("noise_mod", noisemod)

	if (reverse == YES) {
		do j = 0, (ny - 1) {
			for (i = (nx - 1); i >= 0; i = i - 1) {
				call fprintf (fd, " %.4g")
					call pargr (Memr[ip+j*nx+i] / sum)
				if (mod ((nx-1-i),10) == 8)
					call fprintf (fd, "\n")
			}
			call fprintf (fd, ";\n")
		}
	} else {
		for (j = (ny - 1); j >= 0; j = j - 1) {
			do i = 0, (nx - 1) {
				call fprintf (fd, " %.4g")
					call pargr (Memr[ip+j*nx+i] / sum)
				if (mod (i,10) == 8)
					call fprintf (fd, "\n")
			}
			call fprintf (fd, ";\n")
		}
	}

	call imunmap (im)
	call close (fd)
end

# COSFILT: apply a multiplicative cos**2 filter

procedure cosfilt (a, nx, ny, r1, r2)

real	a[nx,ny]
int	nx, ny
real	r1, r2

int	xcen, ycen
int	i, j
real	scale				# (ratio of nx/ny)
real	factor, r

begin
	xcen = nx / 2 + 1
	ycen = ny / 2 + 1
	scale = real (nx) / real (ny)

	factor = HALFPI / (r2 - r1)

	do j = 1, ny
	do i = 1, nx {
		r = sqrt (real (xcen - i) ** 2 + (scale * real (ycen - j)) ** 2)
		if (r >= r2)
			a[i,j] = 0.
		else if (r > r1)
			a[i,j] = a[i,j] * cos ( (r - r1) * factor) ** 2
	}
end
