# QPSF: Quick PSF-match of images (replaces individual macros)
#  Written by A. C. Phillips at Lick Observatory, Jun 94

procedure qpsf (input, output, reference, x, y, z, subrast)

file	input {prompt = "input image"}
file	output {prompt = "output image"}
file	reference {prompt = "reference image"}
real	x {prompt = "x of reference star"}
real	y {prompt = "x of reference star"}
real	z {prompt = "amplitude of reference star"}
string	subrast {prompt = "conv. kernel subraster"}

begin
{

# define local variables
int	ix, iy
string	inp, ref, out
file	kernim, powim
file	qtmp1

inp = input
ref = reference
out = output

if (access (inp//".imh"))
	inp = input//".imh"
else if (access (inp//".fit"))	
	inp = input//".fit"
else if (access (inp//".hhh"))	
	inp = input//".hhh"
if (access (ref//".imh"))
	ref = reference//".imh"
else if (access (ref//".fit"))	
	ref = reference//".fit"
else if (access (ref//".hhh"))	
	ref = reference//".hhh"

if (! access (ref)) {
	beep
        print ""
        print ("Error: "//ref//" does not exist ! -- exiting")
        bye
}
if (! access (inp)) {
	beep
        print ""
        print ("Error: "//inp//" does not exist ! -- exiting")
        bye
}
if (access (out) || access (out//".imh") || access (out//".hhh")) {
	beep
        print ""
        print ("Error: "//out//" already exists ! -- exiting")
        bye
}

qtmp1 = mktemp ("tmpq")

# Get the convolution kernel
#
print ("... calling psfm\n")
ix = x + 0.5
iy = y + 0.5
kernim = mktemp ("tmpk")
powim = mktemp ("tmpp")
psfm (ref, inp, kernim, ix, iy, power=powim, zext=z)
contour (powim,floor=INDEF,ceiling=INDEF,zero=0.,ncontour=16,label-); =gcur
contour (kernim,floor=INDEF,ceiling=INDEF,zero=0.,ncontour=16,label-); =gcur
ankern (kernim)
print ("\n*** Select subraster (format [x1:x2,y1:y2]) : ")
mkkern (kernim//subrast, qtmp1)
convolve (inp, out, qtmp1)
delete (qtmp1, veri-, def+)
imdelete (kernim, veri-, def+)
imdelete (powim, veri-, def+)

}
end
