include	<imhdr.h>
include	<error.h>
include	"itran.h"
include	"futil.h"
 
# T_ITRAN: find linear intensity transform (and apply)
# Written by A.C.Phillips at UW; last modified Jul 94 at Lick Obs.

procedure t_itran()

bool	apply
char	image1[SZ_FNAME]
char	image2[SZ_FNAME]
char	imageout[SZ_FNAME]
char	history[SZ_LINE]
pointer	im1, im2, im3
int	xcen, ycen				# box center
int	nx, ny					# size of box
int	xshift, yshift				# offset to image 2
int	niter					# no. of iterations for fit
int	ncol
real	stats[NPAR]
real	fstats[NFITPAR]
long	v1[IM_MAXDIM], v3[IM_MAXDIM]
pointer	l1, l3

bool	clgetb(), streq()
int	clgeti(), impnlr(), imgnlr()
real	clgetr()
pointer	immap()

begin
	call clgstr ("image1", image1, SZ_FNAME)
	call clgstr ("image2", image2, SZ_FNAME)
	xcen = clgeti ("xcen")
	ycen = clgeti ("ycen")
	nx = clgeti ("nx")
	ny = clgeti ("ny")
	xshift = clgeti ("xshift")
	yshift = clgeti ("yshift")

	EPCX(stats) = clgetr ("xelec_adu")
	READX(stats) = clgetr ("xread_out")
	EPCY(stats) = clgetr ("yelec_adu")
	READY(stats) = clgetr ("yread_out")
	niter = clgeti ("niter")		# number of tests to pass
	apply = clgetb("apply")

	im1 = immap (image1, READ_ONLY, 0)
	im2 = immap (image2, READ_ONLY, 0)

	if (IM_NDIM(im1) == IM_NDIM(im2) &&
			IM_LEN(im1,1) == IM_LEN(im2,1) &&
		 	IM_LEN(im1,2) == IM_LEN(im2,2) )

		call itran (im1, im2, image1, image2, nx, ny, xcen, ycen,
					xshift, yshift, stats, niter, fstats)

	else
		call eprintf ("Incongruous image formats\n")

# need to reorganize with errors 
	if (apply) {
		call clgstr ("out", imageout, SZ_FNAME)
		if (streq (imageout, "")) {
			call eprintf ("ERROR: no output name! \n")
			call erract (EA_FATAL)
		}
# open image and write
		im3 = immap (imageout, NEW_COPY, im1)
		IM_PIXTYPE(im3) = TY_REAL

# add info to image header
		call sprintf (history, SZ_LINE, " * %7f + %6f (itran)\n")
			call pargr (SLOPE[fstats])
			call pargr (YINCPT[fstats])
		call bksp_strcat (history, IM_HISTORY(im3), SZ_IMHIST)

		call hdr_mulr (im3, 1./SLOPE[fstats], "EFFEPC", "MODEPC", YES)
	
# do the copy
		call amovkl (long(1), v1, IM_MAXDIM)
		call amovkl (long(1), v3, IM_MAXDIM)

		ncol = IM_LEN(im1,1)

		while ( impnlr(im3, l3, v3) != EOF ) {
			if (imgnlr (im1, l1, v1) == EOF)
				call eprintf (" READ ERROR\n")
			call altmr (Memr[l1], Memr[l3], ncol, SLOPE[fstats],
								YINCPT[fstats])
		}

		call imunmap (im3)
	}

	call imunmap (im1)
	call imunmap (im2)
end
