# FOURN -- Replaces datas by its n-dimensional discreter Fourier transform,
# if isign is input as 1. NN is an integer array of length ndim containing
# the lengths of each dimension (number of complex values), which must all
# be powers of 2. Data is a real array of length twice the product of these
# lengths, in which the data are stored as in a multidimensional complex
# Fortran array. If isign is input as -1, data is replaced by its inverse
# transform times the product of the lengths of all dimensions.
#
# Borrowed from IRAF at NOAO, Jul/Aug 88 
	
procedure fourn (data, nn, ndim, isign)

real	data[ARB]		# input data
int	nn[ndim]		# array of dimension lengths
int	ndim			# number of dimensions
int	isign			# forward or inverse transform

int	idim, i1, i2, i3, ip1, ip2, ip3, ifp1, ifp2, i2rev, i3rev, k1, k2
int	ntot, nprev, n, nrem, ibit
double	wr, wi, wpr, wpi, wtemp, theta
real	tempr, tempi

begin
	ntot = 1
	do idim = 1, ndim
	    ntot = ntot * nn[idim]

	nprev = 1
	do idim = 1, ndim {

	    n = nn[idim]
	    nrem = ntot / (n * nprev)
	    ip1 = 2 * nprev
	    ip2 = ip1 * n
	    ip3 = ip2 * nrem
	    i2rev = 1

	    do i2 = 1, ip2, ip1 {

	        if (i2 < i2rev) {
		    do i1 = i2, i2 + ip1 - 2, 2 {
		        do i3 = i1, ip3, ip2 {
			    i3rev = i2rev + i3 - i2
			    tempr = data [i3]
			    tempi = data[i3+1]
			    data[i3] = data[i3rev]
			    data[i3+1] = data[i3rev+1]
			    data[i3rev] = tempr
			    data[i3rev+1] = tempi
		        }
		    }
	        }

	        ibit = ip2 / 2
	        while ((ibit >= ip1) && (i2rev > ibit)) {
		    i2rev = i2rev - ibit
		    ibit = ibit / 2
	        }

	        i2rev = i2rev + ibit
	    }

	    ifp1 = ip1
	    while (ifp1 < ip2) {

		ifp2 = 2 * ifp1
		theta = isign * 6.28318530717959d0 / (ifp2 / ip1)
		wpr = - 2.0d0 * dsin (0.5d0 * theta) ** 2
		wpi = dsin (theta)
		wr = 1.0d0
		wi = 0.0d0

	        do i3 = 1, ifp1, ip1 {
		    do i1 = i3, i3 + ip1 - 2, 2 {
			do i2 = i1, ip3, ifp2 {
			    k1 = i2
			    k2 = k1 + ifp1
			    tempr = sngl (wr) * data[k2] - sngl (wi) *
			        data[k2+1]
			    tempi = sngl (wr) * data[k2+1] + sngl (wi) *
				data[k2]
			    data[k2] = data[k1] - tempr
			    data[k2+1] = data[k1+1] - tempi
			    data[k1] = data[k1] + tempr
			    data[k1+1] = data[k1+1] + tempi
			}
		    }
		    wtemp = wr
		    wr = wr * wpr - wi * wpi + wr
		    wi = wi * wpr + wtemp * wpi + wi
		}

	        ifp1 = ifp2
	    }
	    nprev = n * nprev
	}
end
