include <gset.h>
include	"futil.h"

define  KEYSFILE        "alinear$geoscale.key"

#
# T_GEOSCALE -- work out shifts and scales between two sets of coordinates
# Written by A.C.Phillips at UW; last modified Jul 94 at Lick Obs.
#

procedure t_geoscale()

bool	shifts_only
char	coordfile[SZ_FNAME]
int	nx, ny
int	niter
real	bxs, def1err, def2err
pointer	fd

char	tchar
int	npt, ndx, i
real	coeff[2,3]
pointer	xbuf1, ybuf1, xbuf2, ybuf2
pointer	ebufx1, ebufy1, ebufx2, ebufy2
pointer	rbufx, rbufy, wbuf

bool	clgetb()
int	clgeti(), fscan(), nscan()
real	clgetr()
pointer	open()

begin
	call clgstr ("coordfile", coordfile, SZ_FNAME)
	nx = clgeti ("nx")
	ny = clgeti ("ny")
	bxs = -2. * clgetr ("box_size")
	shifts_only = clgetb("shifts_only")
	niter = clgeti ("niter")
	def1err = clgetr ("def_ref_err")
	def2err = clgetr ("def_err")

        fd = open (coordfile, READ_ONLY, TEXT_FILE)
	npt = 0
	while (fscan(fd) != EOF)
		npt = npt + 1
	call seek (fd, BOF)

	call malloc (xbuf1, npt, TY_REAL)		# ref coord
	call malloc (ybuf1, npt, TY_REAL)
	call malloc (xbuf2, npt, TY_REAL)		# input coord
	call malloc (ybuf2, npt, TY_REAL)
	call malloc (ebufx1, npt, TY_REAL)		# error arrays
	call malloc (ebufy1, npt, TY_REAL)
	call malloc (ebufx2, npt, TY_REAL)
	call malloc (ebufy2, npt, TY_REAL)
	call malloc (rbufx, npt, TY_REAL)		# residuals
	call malloc (rbufy, npt, TY_REAL)
	call malloc (wbuf, npt, TY_REAL)		# weights

	call amovkr (1., Memr[wbuf], npt)

# Read in list of coord pairs and errors (and weights if present)
	ndx = 0
	while (fscan(fd) != EOF) {
		call gargwrd (tchar, 1)
		call reset_scan()
		if (tchar == '#') {
			next
		}
		call gargr (Memr[xbuf1+ndx])
		call gargr (Memr[ybuf1+ndx])
		call gargr (Memr[xbuf2+ndx])
		call gargr (Memr[ybuf2+ndx])
		call gargr (Memr[ebufx1+ndx])
		call gargr (Memr[ebufy1+ndx])
		call gargr (Memr[ebufx2+ndx])
		call gargr (Memr[ebufy2+ndx])
		if (nscan() < 4)
			next
		if (nscan() < 8) {
			Memr[ebufx1+ndx] = INDEF
			Memr[ebufy1+ndx] = INDEF
			Memr[ebufx2+ndx] = INDEF
			Memr[ebufy2+ndx] = INDEF
		}
		ndx = ndx + 1
	}

	call close (fd)
	npt = ndx		# npt reduced by rejection of bad pairs

	do i = 0, npt-1 {
		if (Memr[ebufx1+i] == INDEF || Memr[ebufx1+i] <= 0.)
			Memr[ebufx1+i] = def1err
		if (Memr[ebufy1+i] == INDEF || Memr[ebufy1+i] <= 0.)
			Memr[ebufy1+i] = def1err
		if (Memr[ebufx2+i] == INDEF || Memr[ebufx2+i] <= 0.)
			Memr[ebufx2+i] = def2err
		if (Memr[ebufy2+i] == INDEF || Memr[ebufy2+i] <= 0.)
			Memr[ebufy2+i] = def2err
	}

# square the errors, as required for get_lsqf:
	call amulr (Memr[ebufx1], Memr[ebufx1], Memr[ebufx1], npt)
	call amulr (Memr[ebufy1], Memr[ebufy1], Memr[ebufy1], npt)
	call amulr (Memr[ebufx2], Memr[ebufx2], Memr[ebufx2], npt)
	call amulr (Memr[ebufy2], Memr[ebufy2], Memr[ebufy2], npt)

	call geoscale (Memr[xbuf1], Memr[ybuf1], Memr[xbuf2], Memr[ybuf2],
		Memr[ebufx1], Memr[ebufy1], Memr[ebufx2], Memr[ebufy2],
		Memr[rbufx], Memr[rbufy], Memr[wbuf], npt, nx, ny, niter, bxs,
							shifts_only, coeff)

	call printf ("#  refx   refy      x      xres     y      yres     w \n")
	do i = 0, npt-1 {
		call printf ("#%7.2f%7.2f  %7.2f (%5.3f) %7.2f (%5.3f) %6.2f\n")
			call pargr(Memr[xbuf1+i])
			call pargr(Memr[ybuf1+i])
			call pargr(Memr[xbuf2+i])
			call pargr(Memr[rbufx+i])
			call pargr(Memr[ybuf2+i])
			call pargr(Memr[rbufy+i])
			call pargr(Memr[wbuf+i])
	}

	call printf ("#For geotran input:\n")
	call printf ("begin\t%s\n")
		call pargstr (coordfile, SZ_FNAME)
	call printf ("\tsurface1\t11\n")
	call printf ("\t\t\t3.\t3.\n")
	call printf ("\t\t\t2.\t2.\n")
	call printf ("\t\t\t2.\t2.\n")
	call printf ("\t\t\t0.\t0.\n")
	call printf ("\t\t\t1.\t1.\n")
	call printf ("\t\t\t%d.\t%d.\n")
		call pargi (nx)
		call pargi (nx)
	call printf ("\t\t\t1.\t1.\n")
	call printf ("\t\t\t%d.\t%d.\n")
		call pargi (ny)
		call pargi (ny)
	call printf ("\t\t\t%f\t%f\n")
		call pargr (coeff[1,3])
		call pargr (coeff[2,3])
	call printf ("\t\t\t%f\t%f\n")
		call pargr (coeff[1,1])
		call pargr (coeff[2,1])
	call printf ("\t\t\t%f\t%f\n")
		call pargr (coeff[1,2])
		call pargr (coeff[2,2])
	call printf ("\tsurface2\t0\n")
end

#
# GEOSCALE -- work out shifts and scales between two sets of coordinates
#

procedure geoscale (xref, yref, x, y, xrerr, yrerr, xerr, yerr, xres, yres, w,
				npt, nx, ny, niter, bxs, shifts_only, coeff)

real	xref[npt], yref[npt]			# reference coord.
real	x[npt], y[npt]				# input coord.
real	xrerr[npt], yrerr[npt], xerr[npt], yerr[npt]	# error vectors
real	xres[npt], yres[npt]			# residual vectors
real	w[npt]					# weights
int	nx, ny					# image size/plot dimensions
int	npt					# vector lengths
int	niter					# no. of iterations in fit
real	bxs					# box size for unit weight
bool	shifts_only				# find shifts only?
real	coeff[2,3]				# geotran coeffs

real	stats[NFITPAR]				# fit info struct

int	i
real	axx, axy, ayx, ayy, bx, by
real	me1x, me1y, bxerr, byerr
real	vmag

real	ascale
pointer	tbuf			# tmp, used by kludge
real	vsum1(), vsum3()	# ditto

pointer	gp

char	command[32]			# not sure if 32 is good
int	wcs, key
real	wx, wy

int	clgcur(), get_nearest()
real	clgetr()
pointer	gopen()

begin
	if (shifts_only) {
# this can be more elegant; also must put in checks
		axx = 1.
		axy = 0.
		ayx = 0.
		ayy = 1.
		call get_lsqf0 (x, xref, xerr, xrerr, w, npt, stats)
		bx = OFFSET[stats]
		bxerr = EOFFSET[stats]
		me1x = ME1[stats]
		call get_lsqf0 (y, yref, yerr, yrerr, w, npt, stats)
		by = OFFSET[stats]
		byerr = EOFFSET[stats]
		me1y = ME1[stats]
	} else {
		call get_lsqf2 (x, y, xref, xerr, yerr, xrerr, w, npt, niter, stats)
		axx = SLOPE1[stats]
		axy = SLOPE2[stats]
		bx = OFFSET[stats]
		bxerr = EOFFSET[stats]
		me1x = ME1[stats]
		call get_lsqf2 (x, y, yref, xerr, yerr, yrerr, w, npt, niter, stats)
		ayx = SLOPE1[stats]
		ayy = SLOPE2[stats]
		by = OFFSET[stats]
		by = OFFSET[stats]
		byerr = EOFFSET[stats]
	}

	do i = 1, npt {
		xres[i] = xref[i] - (axx * x[i] + axy * y[i] + bx)
		yres[i] = yref[i] - (ayx * x[i] + ayy * y[i] + by)
	}
# The following is a kludge until the lsqf2 errors are done right:
	if (not (shifts_only)) {
		call malloc (tbuf, npt, TY_REAL)
		call adivr (xres, xerr, Memr[tbuf], npt)
		me1x = sqrt (vsum3 (Memr[tbuf], xres, w, npt) / vsum1 (w, npt) )
		call adivr (yres, yerr, Memr[tbuf], npt)
		me1y = sqrt (vsum3 (Memr[tbuf], yres, w, npt) / vsum1 (w, npt) )
		call mfree (tbuf, TY_REAL)
	}
#end kludge

	vmag = 100.
# Open the graphics stream
	gp = gopen ("stdgraph", NEW_FILE, STDGRAPH)

# Plot the data
	call plot_res2d (gp, x, y, xres, yres, w, npt, nx, ny, bxs, vmag)

	while ( clgcur("coord", wx, wy, wcs, key, command, 32) != EOF ) {

	if (key == 'q')
		break
	switch (key) {

	case 'c':
		i = get_nearest (gp, x, y, npt, wx, wy, wcs)
		w[i] = clgetr ("wt")
		if (w[i] == 0.)
			call gmark (gp, x[i], y[i], GM_CROSS, 1., 1.)
		else
			call gmark (gp, x[i], y[i], GM_BOX, w[i]*bxs, w[i]*bxs)

	case 'd':
		i = get_nearest (gp, x, y, npt, wx, wy, wcs)
		w[i] = 0.
		call gmark (gp, x[i], y[i], GM_CROSS, 1., 1.)

	case 'f':
		if (shifts_only) {
# this can be more elegant; also must put in checks
			axx = 1.
			axy = 0.
			ayx = 0.
			ayy = 1.
			call get_lsqf0 (x, xref, xerr, xrerr, w, npt, stats)
			bx = OFFSET[stats]
			bxerr = EOFFSET[stats]
			me1x = ME1[stats]
			call get_lsqf0 (y, yref, yerr, yrerr, w, npt, stats)
			by = OFFSET[stats]
			byerr = EOFFSET[stats]
			me1y = ME1[stats]
		} else {
			call get_lsqf2 (x, y, xref, xerr, yerr, xrerr, w, npt, niter, stats)
			axx = SLOPE1[stats]
			axy = SLOPE2[stats]
			bx = OFFSET[stats]
			bxerr = EOFFSET[stats]
			me1x = ME1[stats]
			call get_lsqf2 (x, y, yref, xerr, yerr, yrerr, w, npt, niter, stats)
			ayx = SLOPE1[stats]
			ayy = SLOPE2[stats]
			by = OFFSET[stats]
			byerr = EOFFSET[stats]
			me1y = ME1[stats]
		}

		do i = 1, npt {
			xres[i] = xref[i] - (axx * x[i] + axy * y[i] + bx)
			yres[i] = yref[i] - (ayx * x[i] + ayy * y[i] + by)
		}
# The following is a kludge until the lsqf2 errors are done right:
	if (not (shifts_only)) {
		call malloc (tbuf, npt, TY_REAL)
		call adivr (xres, xerr, Memr[tbuf], npt)
		me1x = sqrt (vsum3 (Memr[tbuf], xres, w, npt) / vsum1 (w, npt) )
		call adivr (yres, yerr, Memr[tbuf], npt)
		me1y = sqrt (vsum3 (Memr[tbuf], yres, w, npt) / vsum1 (w, npt) )
		call mfree (tbuf, TY_REAL)
	}
#end kludge

		call gclear (gp)
		call plot_res2d (gp, x, y, xres, yres, w, npt, nx, ny, bxs, vmag)

	case 'm':
		vmag = clgetr ("vmag")
		call gclear (gp)
		call plot_res2d (gp, x, y, xres, yres, w, npt, nx, ny, bxs, vmag)
 
	case 'I':
		call fatal (0, "INTERRUPT")

	case '?':
		call gpagefile (gp, KEYSFILE, "geoscale cursor commands")

	}
	}
	
	call gclose (gp)

# Print stats again on text plane
	call printf ("#  x-xform: %7.5fx + %7.5fy  + %7.3f  (%5.3f) [%5.2f]\n")
		call pargr (axx)
		call pargr (axy)
		call pargr (bx)
		call pargr (bxerr)
		call pargr (me1x)
	call printf ("#  y-xform: %7.5fx + %7.5fy  + %7.3f  (%5.3f) [%5.2f]\n")
		call pargr (ayx)
		call pargr (ayy)
		call pargr (by)
		call pargr (byerr)
		call pargr (me1y)

# Now, invert for input to GEOTRAN:
	ascale = axx * ayy - axy * ayx
	coeff[1,1] = ayy / ascale
	coeff[1,2] = -axy / ascale
	coeff[2,1] = -ayx / ascale
	coeff[2,2] = axx / ascale
	coeff[1,3] = - (coeff[1,1] * bx + coeff[1,2] * by)
	coeff[2,3] = - (coeff[2,1] * bx + coeff[2,2] * by)

	return
end

#
# PLOT_RES2D -- plot residuals as vector on 2-d surface
#

procedure	 plot_res2d (gp, x, y, xres, yres, w, npt, nx, ny, bxs, vmag)

pointer	gp
real	x[npt], y[npt]				# position vectors
real	xres[npt], yres[npt]			# residual vectors
real	w[npt]					# weight vector
int	npt					# length of vectors
int	nx, ny					# plot dimension
real	bxs					# box size (neg for WCS)
real	vmag					# residual magnification

char	title[SZ_LINE]
int	i
real	x1, x2, y1, y2
real	wfactor					# box size for full weight
real 	xback, yback		# back-off amounts; should be more elegant

begin
	xback = nx * .04
	yback = ny * .05
	x1 = 1. - xback
	x2 = nx + xback
	y1 = 1. - yback
	y2 = ny + yback
	call gswind (gp, x1, x2, y1, y2)
	call sprintf (title, SZ_LINE, "Residual Vectors; Box Half-Length= %f pix")
		call pargr (-bxs/2.)
	call glabax (gp, title, "X (pix)", "Y (pix)")

	wfactor = bxs * vmag
	for (i = 1; i <= npt; i = i + 1) {
		if (w[i] == 0.)
			call gmark (gp, x[i], y[i], GM_CROSS, 1., 1.)
		else
			call gmark (gp, x[i], y[i], GM_BOX, w[i]*wfactor,
								w[i]*wfactor)
		call grdraw (gp, xres[i]*vmag, yres[i]*vmag)
	}

	call gflush (gp)

	return
end
