include	<imhdr.h>
include <math.h>
include <error.h>
include <fset.h>	#tmp

#
# PSFM: take the DFT of two images, divide, model and inverse transform
# T_PSFM: Calling procedure; file setup
#
# Written by A.C.Phillips at NOAO; last modified Jul 94 at Lick Obs.

procedure t_psfm()

pointer	imagref				# reference image
pointer image				# input image
pointer	imagker				# kernal image
pointer	imagps				# power spectrum image
int	xcen, ycen			# x and y center for data box
int	nx, ny				# x and y size of data box
real	r1, r2				# inner and outer radius of filter
real	edge				# cos bell width for apodization
real 	zoff1, zoff2			# dc offset for reference, input images
real	norm				# flux ratio (ref/input) excluding bkgd.
pointer	title				# title of image kernal
pointer filtopt				# filter|extend|model option
int	radsym				# does filter have radial symmetry?
real	zextend				# abs value of FT below which to replace

int	x1, y1				# x, y lower corner of data box
int	mx, my				# x, y size of FT box (powers of 2)
int	wrtps				# write power spectrum?
int	i
pointer	sp
pointer	im1, im2, im3, im4

bool	clgetb()
int	clgeti(), btoi(), clgwrd()
real	clgetr()
pointer	immap()

begin
#	call fseti (STDOUT, F_FLUSHNL, YES)	#tmp/debug

# Allocate space for strings
	call smark (sp)
	call salloc (imagref, SZ_FNAME, TY_CHAR)
	call salloc (image, SZ_FNAME, TY_CHAR)
	call salloc (imagker, SZ_FNAME, TY_CHAR)
	call salloc (imagps, SZ_FNAME, TY_CHAR)
	call salloc (title, SZ_IMTITLE, TY_CHAR)
	call salloc (filtopt, SZ_LINE, TY_CHAR)

	call clgstr ("image1", Memc[imagref], SZ_FNAME)
	im1 = immap (Memc[imagref], READ_ONLY, 0)
	call clgstr ("image2", Memc[image], SZ_FNAME)
	im2 = immap (Memc[image], READ_ONLY, 0)

	if (IM_NDIM(im1) != IM_NDIM(im2)) {
		call eprintf ("Incongruous images!\n")
		call erract (EA_FATAL)
	}

	xcen = clgeti ("xcen")
	ycen = clgeti ("ycen")
	nx = clgeti ("nx")
	ny = clgeti ("ny")
	x1 = xcen - (nx / 2)
	y1 = ycen - (ny / 2)
# Find power of 2 greater or equal to nx, ny
	for (mx = 1; nx > mx; mx = mx * 2)
		;
	for (my = 1; ny > my; my = my * 2)
		;

	if (x1 < 1 || y1 < 1
		   || (x1+nx-1) > min (IM_LEN(im1,1), IM_LEN(im2,1))
		   || (y1+ny-1) > min (IM_LEN(im1,2), IM_LEN(im2,2))) {
		call eprintf ("x range outside of image!\n")
		call erract (EA_FATAL)
	}

	call clgstr ("imkern", Memc[imagker], SZ_FNAME)
	im3 = immap (Memc[imagker], NEW_IMAGE, im1)
	IM_LEN(im3,1) = nx
	IM_LEN(im3,2) = ny
	IM_NDIM(im3) = 2

	call clgstr ("title", Memc[title], SZ_IMTITLE)
	if (Memc[title] != EOS)
		call strcpy (Memc[title], IM_TITLE(im3), SZ_IMTITLE)   
	
	call clgstr ("power", Memc[imagps], SZ_FNAME)
	if (Memc[imagps] != EOS) {
		wrtps = YES
		im4 = immap (Memc[imagps], NEW_IMAGE, im3)
		IM_LEN(im4,1) = mx
		IM_LEN(im4,2) = my
		IM_NDIM(im4) = 2
	} else {
		wrtps = NO
	}

	edge = clgetr ("edgepix")
	zoff1 = clgetr ("dc1")
	zoff2 = clgetr ("dc2")
	norm = clgetr ("fluxratio")
	zextend = clgetr ("zextend")
	r1 = clgetr ("r1")
	r2 = clgetr ("r2")
	radsym = btoi (clgetb ("radsym"))
	i = clgwrd ("filtopt", Memc[filtopt], SZ_LINE, "|filter|extend|model|")

	call psfm (im1, im2, im3, im4, x1, y1, nx, ny, mx, my, wrtps, edge,
		zoff1, zoff2, norm, zextend, r1, r2, radsym, Memc[filtopt])

	call imunmap (im1)
	call imunmap (im2)
	call imunmap (im3)
	if (wrtps == YES)
		call imunmap (im4)
	call sfree (sp)
end

#
# PSFM: get the FTs, divide and inverse-transform; apply filters as requested
#

procedure psfm (im1, im2, im3, im4, x1, y1, nx, ny, mx, my, wrtps, edge, zoff1,
			zoff2, norm, zextend, r1, r2, radsym, option)

pointer	im1, im2, im3, im4
int	x1, y1, nx, ny, mx, my, wrtps
real	edge, zoff1, zoff2, norm, r1, r2, zextend
int	radsym
char	option[ARB]

int	npix, mpix, mm[2]
pointer	s1, s2, s3, s4, cv1, cv2

bool	streq()
real	gauss_amp()
pointer	imgs2r(), imps2r()

begin
	npix = nx * ny
	mpix = mx * my

# Map the input images

	s1 = imgs2r (im1, x1, (x1+nx-1), y1, (y1+ny-1))
	s2 = imgs2r (im2, x1, (x1+nx-1), y1, (y1+ny-1))

# Subtract the offset (if there is any given)

	if (zoff1 != 0.)
		call aaddkr (Memr[s1], -zoff1, Memr[s1], npix)
	if (zoff2 != 0.)
		call aaddkr (Memr[s2], -zoff2, Memr[s2], npix)

# Apply apodizing function

	if (edge > 0.) {
		call taper (Memr[s1], nx, ny, edge)
		call taper (Memr[s2], nx, ny, edge)
	}

# Allocate and pack complex buffers, expanding to mx*my

	call malloc (cv1, mpix, TY_COMPLEX)
	call malloc (cv2, mpix, TY_COMPLEX)
	call pack_xvector (Memr[s1], nx, ny, Memx[cv1], mx, my)
	call pack_xvector (Memr[s2], nx, ny, Memx[cv2], mx, my)

# Apply shift to center, so that filters are easier to apply (may disappear)
	call half_shift (Memx[cv1], mx, my)
	call half_shift (Memx[cv2], mx, my)
	
# Get the FTs (Cave! note that fourn does not check for power of 2!)
	mm[1] = mx
	mm[2] = my
	call fourn (Memx[cv1], mm, 2, 1)
	call fourn (Memx[cv2], mm, 2, 1)

# Find normalization
	if (norm == 0.)
	    norm = gauss_amp (Memx[cv1], mx, my) / gauss_amp (Memx[cv2], mx, my)
	call printf ("Flux ratio used: %.3g\n")
		call pargr (norm)

# Divide im1 (ref) by im2 (input); fix central pixel (dc-offset of ratio)

	call adivx (Memx[cv1], Memx[cv2], Memx[cv1], mpix)

	Memx[cv1+(my+1)*mx/2] = complex (norm, 0.)

# Noise reduction: filter

	if (streq (option, "filter") && r1 != 0. && r2 != 0.)
		call filter (Memx[cv1], mx, my, r1, r2, radsym)
	if (streq (option, "extend") || streq (option, "model"))
		call gauss_replace (Memx[cv1], Memx[cv2], mx, my, zextend, norm,
								option)
	call norm_filt (Memx[cv1], mpix, norm)

	if (wrtps == YES) {
		s4 = imps2r (im4, 1, mx, 1, my)
		call aabsxr (Memx[cv1], Memr[s4], mpix)
	}

# Calculate the inverse transform; normalize and store real part in image3

	call half_shift (Memx[cv1], mx, my)
	call fourn (Memx[cv1], mm, 2, -1)
	call half_shift (Memx[cv1], mx, my)

	s3 = imps2r (im3, 1, nx, 1, ny)

	call unpack_xvector (Memx[cv1], mx, my, Memr[s3], nx, ny)
	call adivkr (Memr[s3], real (npix), Memr[s3], npix)

# Free memory

	call mfree (cv1, TY_COMPLEX)
	call mfree (cv2, TY_COMPLEX)
end

#
# AABSXR: get the absolute value of a complex vector & put in real vector
#

procedure aabsxr (a, b, n)

complex	a[ARB]					# input complex vector
real	b[ARB]					# output real vector
int	n					# number of elements in a,b

int	i

begin
	do i = 1, n
		b[i] = abs (a[i])
end

procedure taper (a, nx, ny, edge)

real	a[nx,ny]
int	nx, ny
real	edge

int	i, j
real	cos2

begin
    # can this be cleaned up?
	do j = 0, int (edge) {
		cos2 = sin (real (j) / edge * HALFPI) ** 2
		call amulkr (a[1,(j+1)], cos2, a[1,(j+1)], nx)
		if (j != 0)
			call amulkr (a[1,(ny-j+1)], cos2, a[1,(ny-j+1)], nx)
	}

	do i = 0, int (edge) {
		cos2 = sin (real (i) / edge * HALFPI) ** 2
		do j = 1, ny {
			a[i+1,j] = cos2 * a[i+1,j]
			if (i != 0)
				a[nx-i+1,j] = cos2 * a[nx-i+1,j]
		}
	}
end

# FILTER: apply a multiplicative filter (currently not very efficient code?)

procedure filter (a, nx, ny, r1, r2, radsym)

complex	a[nx,ny]
int	nx, ny
real	r1, r2
int	radsym

int	xcen, ycen
int	i, j
real	factor, cos2, r

begin
	xcen = nx / 2 + 1
	ycen = ny / 2 + 1

	factor = HALFPI / (r2 - r1)

	if (radsym == NO) {
		do j = 1, ny {
			r = abs (ycen - j)
			if (r >= r2)
				cos2 = 0.
			else if (r <= r1)
				cos2 = 1.
			else
				cos2 = cos ( (r - r1) * factor) ** 2
			call amulkx (a[1,j], complex (cos2, 0.), a[1,j], nx)
		}
		do i = 1, nx {
			r = abs (xcen - i)
			if (r >= r2)
				cos2 = 0.
			else if (r <= r1)
				cos2 = 1.
			else
				cos2 = cos ( (r - r1) * factor) ** 2
			do j = int (ycen - r2 + 1), int (ycen + r2)
				a[i,j] = a[i,j] * cos2
		}
	} else {
		do j = 1, ny
		do i = 1, nx {
			r = sqrt (real (xcen - i) ** 2 + real (ycen - j) ** 2)
			if (r >= r2)
				a[i,j] = 0.
			else if (r > r1 && r < r2)
				a[i,j] = a[i,j] * cos ( (r - r1) * factor) ** 2
			}
	}
end

#
# NORM_FILT: normalize values where abs. value is greater than "norm"
#

procedure norm_filt (a, npix, norm)

complex	a[ARB]
int	npix
real	norm

int	i

begin
	do i = 1, npix
		if (abs (a[i]) > norm)
			a[i] = a[i] / abs (a[i]) * norm
end

#
# GAUSS_REPLACE: replace low-valued regions of kernal FT with gaussian extension
#

procedure gauss_replace (a, d, nx, ny, zext, norm, option)

complex	a[nx,ny]				# kernal FT
complex	d[nx,ny]				# divisor
int	nx, ny
real	zext
real	norm
char	option[ARB]

int	xcen, ycen
int	i, j
real	x, y, z, wt
real	sxxxx, sxxxy, sxxyy, sxyyy, syyyy, sxxz, sxyz, syyz
real	sxx, sxy, syy, sxz, syz
real	a1, a2, a3, u, v
real	phi, absv
pointer	mtrx

bool	streq()

begin
	xcen = nx / 2 + 1
	ycen = ny / 2 + 1

	sxxxx = 0.
	sxxxy = 0.
	sxxyy = 0.
	sxyyy = 0.
	syyyy = 0.
	sxxz = 0.
	sxyz = 0.
	syyz = 0.
	sxx = 0.
	sxy = 0.
	syy = 0.
	sxz = 0.
	syz = 0.

	do j = 1, ny
	do i = 1, nx {
		if (abs (d[i,j]) < zext)
			next
		if (i == xcen && j == ycen)
			next
		x = i - xcen
		y = j - ycen
		z = log (abs (a[i,j]) / norm)
		wt = 1. / sqrt (x * x + y * y)
		sxxxx = sxxxx + x * x * x * x * wt
		sxxxy = sxxxy + x * x * x * y * wt
		sxxyy = sxxyy + x * x * y * y * wt
		sxyyy = sxyyy + x * y * y * y * wt
		syyyy = syyyy + y * y * y * y * wt
		sxxz = sxxz + x * x * z * wt
		sxyz = sxyz + x * y * z * wt
		syyz = syyz + y * y * z * wt
		wt = abs (a[i,j]) / norm
		z = atan2 ( aimag (a[i,j]), real (a[i,j]))	# atan2 necess.?
		sxx = sxx + x * x * wt
		sxy = sxy + x * y * wt
		syy = syy + y * y * wt
		sxz = sxz + x * z * wt
		syz = syz + y * z * wt
	}
# Solve matrices: this should all be replaced by appropriate existing routines
# exp (a1xx + a2xy + a3yy)
# cos (ux + vy); sin (ux + vy)

	call malloc (mtrx, 12, TY_REAL)		# prob. should DOUBLE
	Memr[mtrx+0] = sxxxx
	Memr[mtrx+1] = sxxxy
	Memr[mtrx+2] = sxxyy
	Memr[mtrx+3] = sxxz
	Memr[mtrx+4] = sxxxy
	Memr[mtrx+5] = sxxyy
	Memr[mtrx+6] = sxyyy
	Memr[mtrx+7] = sxyz
	Memr[mtrx+8] = sxxyy
	Memr[mtrx+9] = sxyyy
	Memr[mtrx+10] = syyyy
	Memr[mtrx+11] = syyz
	call g_elim (Memr[mtrx], 3)
	a1 = Memr[mtrx+3]
	a2 = Memr[mtrx+7]
	a3 = Memr[mtrx+11]
	Memr[mtrx+0] = sxx
	Memr[mtrx+1] = sxy
	Memr[mtrx+2] = sxz
	Memr[mtrx+3] = sxy
	Memr[mtrx+4] = syy
	Memr[mtrx+5] = syz
	call g_elim (Memr[mtrx], 2)
	u = Memr[mtrx+2]
	v = Memr[mtrx+5]
	call mfree (mtrx, TY_REAL)

	call eprintf ("a1,a2,a3= %.4g, %.4g, %.4g\n")
		call pargr (a1)
		call pargr (a2)
		call pargr (a3)
	call eprintf ("u,v= %.4g, %.4g;  implied shift x:%5.2f  y:%5.2f\n")
		call pargr (u)
		call pargr (v)
		call pargr (u / TWOPI * nx)
		call pargr (v / TWOPI * ny)

	if (streq (option, "extend")) {
# Replace the values below zext
	do j = 1, ny
	do i = 1, nx {
		if (abs (d[i,j]) < zext) {
			x = i - xcen
			y = j - ycen
			absv = norm * exp (a1 * x * x + a2 * x * y + a3 * y * y)
			phi = u * x + v * y
			a[i,j] = complex (absv * cos (phi), absv * sin (phi))
		}
	}
	} else if (streq (option, "model")) {
# Replace with model
		do j = 1, ny
		do i = 1, nx {
			x = i - xcen
			y = j - ycen
			absv = norm * exp (a1 * x * x + a2 * x * y + a3 * y * y)
			phi = u * x + v * y
			a[i,j] = complex (absv * cos (phi), absv * sin (phi))
		}
	}

	do i = 1, nx
		a[i,1] = complex (abs (a[i,1]), 0.)
	do j = 2, ny
		a[1,j] = complex (abs (a[1,j]), 0.)
end

#
# G_ELIM: procedure for gaussian elimination, n var's

procedure g_elim (a, n)

real	a[n+1,n]			# matrix to be solved
int	n				# number of variables

int	i, j, k
real	den, hold

begin
#	call pmat (a, n, 0)
	do k = 1, n {
		den = a[k,k]
		if (den == 0.) {		# look for non-zero: switch
			do j = (k+1), n {
				if (a[k,k] != 0.) {
					do i = k, (n+1) {
						hold = a[i,j]
						a[i,j] = a[i,k]
						a[i,k] = hold
					}
				den = a[k,k]
				}
			}
			if (den == 0.)			# if still zero, skip
				next
		}
		do i = k, (n+1)
			a[i,k] = a[i,k] / den
		do j = 1, n
			if (j != k) {
				den = a[k,j]
				do i = k, (n+1)
					a[i,j] = a[i,j] - a[i,k] * den
			}
	}
end
	
#
# PMAT: print matrix -- DIAGNOSTIC ONLY
#

procedure pmat(a, n, k)

real	a[n+1,n]
int	n, k, i

begin
	call printf ("pmat: k=%3d\n")
		call pargi (k)
	if (n == 2) {
		do i = 1, n {
		call printf ("pmat: %.6g  %.6g    %.6g\n")
		call pargr (a[1,i])
		call pargr (a[2,i])
		call pargr (a[3,i])
		}
	} else {
		do i = 1, n {
		call printf ("pmat: %.6g  %.6g  %.6g    %.6g\n")
		call pargr (a[1,i])
		call pargr (a[2,i])
		call pargr (a[3,i])
		call pargr (a[4,i])
		}
	}
end

# GAUSS_AMP:  find the amplitude of a gaussian
# (This is probably a TEMPORARY procedure, used in determining flux ratio.
# Perhaps should be replaced to include general gaussian fit.)
#  gaussian = c * exp (b*r*r); c (amplitude) is returned; averages x&y soln.

real procedure gauss_amp (a, nx, ny)

complex	a[nx,ny]
int	nx, ny

int	xcen, ycen
real	cx, cy, ln1, ln2

begin
	xcen = nx / 2 + 1
	ycen = ny / 2 + 1

	if (nx >= 4) {
		ln1 = log (abs (a[xcen-1,ycen]))
		ln2 = log (abs (a[xcen-2,ycen]))
		cx = exp ( (4. * ln1 - ln2) / 3.)
	}

	if (ny >= 4) {
		ln1 = log (abs (a[xcen,ycen-1]))
		ln2 = log (abs (a[xcen,ycen-2]))
		cy = exp ( (4. * ln1 - ln2) / 3.)
	}

	if (cx == 0.)
		return (cy)
	else if (cy == 0.)
		return (cx)
	else
		return (0.5 * (cx + cy))
end

#
# [UN]PACK_XVECTOR: pack real nx*ny array into complex mx*my array
#

procedure pack_xvector (rv, nx, ny, cv, mx, my)

real	rv[nx,ny]			# real (input) array
int	nx, ny
complex	cv[mx,my]			# Complex (output) array
int	mx, my

int	xoff, yoff, j

begin
	if (nx == mx && ny == my)
		call achtrx (rv, cv, (nx * ny))
	else {
		xoff = (mx - nx) / 2
		xoff = xoff + mod (xoff, 2)
		yoff = (my - ny) / 2
		yoff = yoff + mod (yoff, 2)
		call amovkx (cv, complex (0., 0.), cv, (mx * my))
		do j = 1, ny
			call achtrx (rv[1,j], cv[xoff+1,yoff+j], nx)
	}
	return

entry unpack_xvector (cv, mx, my, rv, nx, ny)

	if (nx == mx && ny == my)
		call achtxr (cv, rv, (nx * ny))
	else {
		xoff = (mx - nx) / 2
		xoff = xoff + mod (xoff, 2)
		yoff = (my - ny) / 2
		yoff = yoff + mod (yoff, 2)
		do j = 1, ny
			call achtxr (cv[xoff+1,yoff+j], rv[1,j], nx)
	}
	return

end

#
# HALF_SHIFT: apply shift theorem for 1/2 array shift.
#

procedure half_shift (a, nx, ny)

complex	a[nx,ny]				# input array
int	nx, ny

int	i, j, off

begin
	do j = 1, ny {
		off = mod (j,2)
		do i = (1 + off), nx, 2
			a[i,j] = a[i,j] * complex (-1., 0.)
	}
end

