include	<error.h>

#
# XYTRANS: Simple linear transformation of coord list, based on 2-pt mapping
# Assumes input coord list, new position of first two points.
# User supplies inversion info
# Written by A.C.Phillips at Lick Obs.; last modified Jul 94 at Lick Obs.
# 25jan99 -- fixed bool inconsistency

procedure t_xytrans()

char	coordsin[SZ_FNAME]		# input file (x, y)
char	xcoords[SZ_FNAME]		# output file (x, y)-xformed
real	x1, y1, x2, y2			# new (x,y) of first, second point
bool	shifts_only			# calculate shifts only?
bool	invert				# is there an inversion in transformatn?
bool	ck_bounds			# output only values within nxt, nyt
real	nxt, nyt			# Size of new image (used as real)
real	tol				# tolerance at edge for ck_bounds
char    coordsout[SZ_FNAME]             # output file of old (x, y) in common

pointer	fda, fdb, fdc

bool	common				# print old coords in common
char	tchar
int	npts
real	x0, y0, x01, y01, x02, y02
real	x, y
double	c11, c12, c21, c22, xoff, yoff
double	dx, dy, dx0, dy0, rsq, r0sq

bool	clgetb(), strne()
int	fscan(), nscan(), clgeti()
real	clgetr()
pointer	open()

begin

# Open input and output files
	call clgstr ("coord", coordsin, SZ_FNAME)
	fda = open (coordsin, READ_ONLY, TEXT_FILE)
	call clgstr ("output", xcoords, SZ_FNAME)
	fdb = open (xcoords, NEW_FILE, TEXT_FILE)
	x1 = clgetr ("x1")
	y1 = clgetr ("y1")
	shifts_only = clgetb ("shifts_only")
	if (shifts_only) {
		invert = false
	} else {
		x2 = clgetr ("x2")
		y2 = clgetr ("y2")
		invert = clgetb ("inversion")
	}
	ck_bounds = clgetb ("ck_bounds")
	if (ck_bounds) {
		call clgstr ("common_out", coordsout, SZ_FNAME)
		common = strne (coordsout, "")
		if (common)
			fdc = open (coordsout, NEW_FILE, TEXT_FILE)
		nxt = clgeti ("nxt")
		nyt = clgeti ("nyt")
		tol = clgetr ("tol")
		nxt = nxt - tol			# Back off by tol
		nyt = nyt - tol
		tol = 1. + tol
	}
	
# Read in first 1 or two points for transformation
	npts = 0
	while (fscan (fda) != EOF) {
		call gargwrd (tchar, 1)
		call reset_scan()
		if (tchar == '#' || tchar == EOS) {
			call fprintf (fdb, " #\n")
			next
		}
		call gargr (x0)
		call gargr (y0)
		if (nscan() < 2) {
			call eprintf ("Poorly formatted coord. list \n")
			call erract (EA_FATAL)
		}
		npts = npts + 1
		if (npts == 1) {
			x01 = x0
			y01 = y0
		} else {
			x02 = x0
			y02 = y0
		}
		if (shifts_only || npts == 2)
			break
	}
	if (npts == 0) {
		call eprintf ("No entries in coord list!\n")
		call erract (EA_FATAL)
	}
	if (!shifts_only && npts < 2) {
		call eprintf ("Needs at least two entries in coord list!\n")
		call erract (EA_FATAL)
	}

# Work out transformation:
	if (shifts_only) {
		c11 = 1.
		c12 = 0.
		c21 = 0.
		c22 = 1.
	} else {
		dx = x2 - x1
		dy = y2 - y1
		dx0 = x02 - x01
		dy0 = y02 - y01
		rsq = dx*dx + dy*dy
		r0sq = dx0*dx0 + dy0*dy0
		if (invert) {
			c12 = (dx*dy0 + dy*dx0) / r0sq
			c11 = (c12*dx0 - dy) / dy0	# problem if dy0 == 0.
			c22 = -c11
			c21 =  c12
		} else {
			c12 = (dx*dy0 - dy*dx0) / r0sq
			c11 = (c12*dx0 + dy) / dy0	# problem if dy0 == 0.
			c22 =  c11
			c21 = -c12
		}
	}
	xoff = x1 - (c11*x01 + c12*y01)
	yoff = y1 - (c21*x01 + c22*y01)

	call printf ("# x = %7.4f*x0 + %7.4f*y0 + %7.2f \n")
		call pargd (c11)
		call pargd (c12)
		call pargd (xoff)
	call printf ("# y = %7.4f*x0 + %7.4f*y0 + %7.2f \n")
		call pargd (c21)
		call pargd (c22)
		call pargd (yoff)

# Rewind coord list
        call seek (fda, BOF)

# Read in values, print out transformed values
	npts = 0
	while (fscan (fda) != EOF) {
		call gargwrd (tchar, 1)
		call reset_scan()
		if (tchar == '#' || tchar == EOS) {
			next
		}
		call gargr (x0)
		call gargr (y0)
		if (nscan() < 2) {
			call eprintf ("WARNING: input line skipped\n")
			next
		}
		if (x0 == INDEF || y0 == INDEF) {
			call eprintf ("WARNING: INDEF's (input line skipped)\n")
			next
		}
		x = c11 * x0 + c12 * y0 + xoff
		y = c21 * x0 + c22 * y0 + yoff
		if (ck_bounds) {
			if (x < tol || x > nxt || y < tol || y > nyt)
				next
		}
		call fprintf (fdb, "%f  %f \n")
			call pargr (x)
			call pargr (y)
		if (common) {
			call fprintf (fdc, "%f  %f \n")
				call pargr (x0)
				call pargr (y0)
		}
		npts = npts + 1
	}

	call printf ("# %d pairs in output list\n")
		call pargi (npts)

# Close up
	call close (fda)
	call close (fdb)
	if (common)
		call close (fdc)
end
