include <imhdr.h>
include <gset.h>
include "itran.h"
include "futil.h"

define  KEYSFILE        "alinear$itran.key"

# ITRAN
# Compare two image sections graphically
#
# Written by A.C.Phillips at UW; last modified Jul 94 at Lick Obs.
# 25jan99 -- fixed bool inconsistency

procedure itran (im1, im2, image1, image2, nx, ny, xc, yc, xs, ys, stats, nit,
									fstats)

pointer	im1, im2		# image pointers
char	image1[ARB]		# image1 name
char	image2[ARB]		# image2 name
int	nx, ny			# size of box
int	xc, yc			# box center
int	xs, ys			# x,y shift to image 2
real	stats[NPAR]		# vector of noise info
int	nit			# no. of iterations
real	fstats[NFITPAR]		# fit stats

real	dr1, dr2			# inner, outer deletion radii


bool	residual
char	lastop
int	j
int	npix, x1, x2, y1, y2
int	npt
real	xro, yro, xepa, yepa, rox2, roy2
pointer	zbufx, zbufy, ebufx, ebufy, zbufr, zbuf, wbuf
pointer	gp

char	command[32]			# not sure if 32 is good
int	wcs, key
real	wx, wy

pointer	imgs2r(), gopen()
int	clgcur(), get_nearest()
real	clgetr()

begin
	x1 = xc - nx / 2
	y1 = yc - ny / 2
	x2 = x1 + nx - 1
	y2 = y1 + ny - 1
	npix = nx * ny

	zbufx = imgs2r (im1, x1, x2, y1, y2)
	zbufy = imgs2r (im2, x1+xs, x2+xs, y1+ys, y2+ys)

# Set up the error vectors (these are error**2 in counts):
	call malloc (ebufx, npix, TY_REAL)
	call malloc (ebufy, npix, TY_REAL)
	xro = READX[stats]
	yro = READY[stats]
	xepa = EPCX[stats]
	yepa = EPCY[stats]
	rox2 = xro * xro / xepa
	roy2 = yro * yro / yepa

	do j = 0, npix-1 {
		Memr[ebufx+j] = (Memr[zbufx+j] + rox2)/xepa
		Memr[ebufy+j] = (Memr[zbufy+j] + roy2)/yepa
	}

# Set up weights = 1.
	call malloc (wbuf, npix, TY_REAL)
	call amovkr (1., Memr[wbuf], npix)

# Get a working vector for residuals
	call malloc (zbufr, npix, TY_REAL)

# Open the graphics stream
	gp = gopen ("stdgraph", NEW_FILE, STDGRAPH)

# Plot the data and work out stats
	zbuf = zbufy
	residual = false
	call plot_points (gp, image1, image2, Memr[zbufx], Memr[zbufy],
							Memr[wbuf], npix)

	call get_lsqf1 (Memr[zbufx], Memr[zbufy], Memr[ebufx], Memr[ebufy],
					Memr[wbuf], npix, nit, fstats)
	call printf ("slope=%7.4f (%6.4f), offset=%7.2f (%5.2f), chi = %6.4f\n")
		call pargr (SLOPE[fstats])
		call pargr (ESLOPE[fstats])
		call pargr (YINCPT[fstats])
		call pargr (EYINCPT[fstats])
		call pargr (CHI[fstats])
	call altmr (Memr[zbufx], Memr[zbufr], npix, SLOPE[fstats],
								YINCPT[fstats])
	call asubr (Memr[zbufy], Memr[zbufr], Memr[zbufr], npix)

	lastop = 'u'
	npt = 0

	while ( clgcur("coord", wx, wy, wcs, key, command, 32) != EOF ) {

	if (key == 'q')
		break
	switch (key) {

	case 'c':
		npt = get_nearest (gp, Memr[zbufx], Memr[zbuf], npix,
								wx, wy, wcs)
	case 'd':
# This will be a delete point option
#		if (motion (gp, wx, wy, wcs...)) print message, next
		npt = get_nearest (gp, Memr[zbufx], Memr[zbuf], npix,
								wx, wy, wcs)
		call mark_pts (gp, Memr[zbufx], Memr[zbuf], Memr[wbuf], nx, ny,
						 npt, 0., 0., YES)
		lastop = 'd'

	case 'f':
	call get_lsqf1 (Memr[zbufx], Memr[zbufy], Memr[ebufx], Memr[ebufy],
					Memr[wbuf], npix, nit, fstats)
		call altmr (Memr[zbufx], Memr[zbufr], npix, SLOPE[fstats],
								YINCPT[fstats])
		call asubr (Memr[zbufy], Memr[zbufr], Memr[zbufr], npix)
		call gclear (gp)
		call plot_points (gp, image1, image2, Memr[zbufx], Memr[zbuf],
							Memr[wbuf], npix)
		call printf ("slope=%7.4f (%6.4f), offset=%7.2f (%5.2f), chi = %6.4f\n")
			call pargr (SLOPE[fstats])
			call pargr (ESLOPE[fstats])
			call pargr (YINCPT[fstats])
			call pargr (EYINCPT[fstats])
			call pargr (CHI[fstats])
		
	case 'l':
		call gclear (gp)
		zbuf = zbufy
		call plot_points (gp, image1, image2, Memr[zbufx], Memr[zbuf],
							Memr[wbuf], npix)
		call printf ("slope=%7.4f (%6.4f), offset=%7.2f (%5.2f), chi = %6.4f\n")
			call pargr (SLOPE[fstats])
			call pargr (ESLOPE[fstats])
			call pargr (YINCPT[fstats])
			call pargr (EYINCPT[fstats])
			call pargr (CHI[fstats])
		residual = false

	case 'a':
		npt = get_nearest (gp, Memr[zbufx], Memr[zbuf], npix,
								wx, wy, wcs)
		dr1 = clgetr("delrad1")
		dr2 = clgetr("delrad2")
		call mark_pts (gp, Memr[zbufx], Memr[zbuf], Memr[wbuf],
						 nx, ny, npt, dr1, dr2, YES)

	case 'n':
		dr1 = clgetr("delrad1")
		dr2 = clgetr("delrad2")
		if (lastop == 'u')
			call mark_pts (gp, Memr[zbufx], Memr[zbuf], Memr[wbuf],
						 nx, ny, npt, dr1, dr2, NO)
		else
			call mark_pts (gp, Memr[zbufx], Memr[zbuf], Memr[wbuf],
						 nx, ny, npt, dr1, dr2, YES)

	case 'r':
		zbuf = zbufr
		call gclear (gp)
		call plot_points (gp, image1, image2, Memr[zbufx], Memr[zbuf],
							Memr[wbuf], npix)
		call printf ("slope=%7.4f (%6.4f), offset=%7.2f (%5.2f), chi = %6.4f\n")
			call pargr (SLOPE[fstats])
			call pargr (ESLOPE[fstats])
			call pargr (YINCPT[fstats])
			call pargr (EYINCPT[fstats])
			call pargr (CHI[fstats])
		residual = true
		
	case 'u':
# this will be an undelete point option
		call mark_pts (gp, Memr[zbufx], Memr[zbuf], Memr[wbuf], nx, ny,
							 npt, 0., 0., NO)
		lastop = 'u'
 
	case 'I':
		call fatal (0, "INTERRUPT")

	case '?':
		call gpagefile (gp, KEYSFILE, "itran cursor commands")

	}
	}
	
	call gclose (gp)

	call mfree (zbufr, TY_REAL)

# Print stats again on text plane
	call get_lsqf1 (Memr[zbufx], Memr[zbufy], Memr[ebufx], Memr[ebufy],
					Memr[wbuf], npix, nit, fstats)
	call printf ("slope=%7.4f (%6.4f), offset=%7.2f (%5.2f), chi = %6.4f\n")
		call pargr (SLOPE[fstats])
		call pargr (ESLOPE[fstats])
		call pargr (YINCPT[fstats])
		call pargr (EYINCPT[fstats])
		call pargr (CHI[fstats])

	return
end

int procedure get_nearest (gp, xdata, ydata, ndata, wx, wy, wcs)

pointer	gp
real 	xdata[ARB], ydata[ARB]
int	ndata
real	wx, wy
int	wcs

int	nearest, i
real	ycorr
real	rsq, rsq_min
real	xndc, yndc, xgcndc, ygcndc

real	ggetr()

begin

# need to put in INDEF check 

# Get aspect ratio 
	ycorr = ggetr (gp, "ar")
	if (ycorr == 0.)
		ycorr = 1.

	rsq_min = 2.			# by def'n larger than NDC possible
	nearest = 0

	call gctran (gp, wx, wy, xgcndc, ygcndc, wcs, 0)

	do i = 1, ndata {
		call gctran (gp, xdata[i], ydata[i], xndc, yndc, wcs, 0)
		rsq = (xndc - xgcndc) ** 2 + ( (yndc - ygcndc) * ycorr) ** 2
		if (rsq < rsq_min) {
			rsq_min = rsq
			nearest = i
		}
	}

	if (nearest != 0)
		call gscur (gp, xdata[nearest], ydata[nearest])
	
	return (nearest)
end

# PLOT_POINTS plots data as points -- expected to change; otherwise put inline

procedure plot_points (gp, image1, image2, xdata, ydata, weight, npts)

pointer	gp
char	image1[ARB], image2[ARB]
real	xdata[ARB], ydata[ARB]
real	weight[ARB]
int	npts

int	i, ngpix1, ngpix2
real	x1, x2, y1, y2
real 	xback, yback		# back-off amounts; should be more elegant

int	alimr()

begin
	ngpix1 = alimr (xdata, npts, x1, x2)
	ngpix2 = alimr (ydata, npts, y1, y2)
	xback = abs (x1 - x2) * .04
	yback = abs (y1 - y2) * .05
	x1 = x1 - xback
	x2 = x2 + xback
	y1 = y1 - yback
	y2 = y2 + yback
	call gswind (gp, x1, x2, y1, y2)
	call glabax (gp, "", image1, image2)

	for (i = 1; i <= npts; i = i + 1) {
		call gmark (gp, xdata[i], ydata[i], GM_POINT, 1., 1.)
		if (weight[i] == 0.)
			call gmark (gp, xdata[i], ydata[i], GM_BOX, 2., 2.)
	}

	call gflush (gp)
end

#
# MARK_PTS: delete/undelete & mark [a region of] points
#

procedure mark_pts (gp, xvec, yvec, wvec, nx, ny, npt, r1, r2, delete)

pointer	gp				# graphics pointer
real	xvec[ARB]			# x values
real	yvec[ARB]			# y values
real	wvec[ARB]			# weights
int	nx, ny				# dimensions of section
int	npt				# sequential number of the pixel
real	r1, r2				# inner, outer radii around pixel
int	delete				# delete point(s)?

int	ix, iy, ipt
int	i, j, i1, i2, j1, j2
real	rsq, rsq1, rsq2

begin
	if (delete == YES)
		call gseti (gp, G_PMLTYPE, 1)
	else
		call gseti (gp, G_PMLTYPE, 0)
 
	if (r2 < 1.) {
		call gmark (gp, xvec[npt], yvec[npt], GM_BOX, 2., 2.)
		if (delete == YES)
			wvec[npt] = 0.
		else
			wvec[npt] = 1.
	} else {
		rsq1 = r1 * r1
		rsq2 = r2 * r2
		ix = mod (npt, nx)
		iy = (npt - ix) / nx + 1
		i1 = max (ix - int (r2), 1) - ix
		j1 = max (iy - int (r2), 1) - iy
		i2 = min (ix + int (r2), nx) - ix
		j2 = min (iy + int (r2), ny) - iy
		call printf ("ix,iy,i1,i2,j1,j2: %d %d %d %d %d %d\n")
			call pargi (ix)
			call pargi (iy)
			call pargi (i1)
			call pargi (i2)
			call pargi (j1)
			call pargi (j2)
		do j = j1, j2
		do i = i1, i2 {
			rsq = j * j + i * i
			if (rsq >= rsq1 && rsq <= rsq2) {
				ipt = (iy + j - 1) * nx + ix + i
			call gmark (gp, xvec[ipt], yvec[ipt], GM_BOX, 2., 2.)
			if (delete == YES)
				wvec[ipt] = 0.
			else
				wvec[ipt] = 1.
			}
		}
	}

end
