# QCOORDS: Quick coord. list routine, for use with qregister, qpsf
#  Written by A. C. Phillips at Lick Observatory, Jun 94

procedure qcoords (input, coordlist, dispim)

file	input {prompt = "input image"}
file	coordlist {prompt = "output coordinate list"}
bool	dispim {prompt = "Display image?"}

begin
{

# define local variables
real	x, y
file	inp, coordout
file	qtmp1

# Construct names
inp = input
coordout = coordlist

if (access (inp//".imh"))
	inp = input//".imh"
else if (access (inp//".fit"))	
	inp = input//".fit"
else if (access (inp//".hhh"))	
	inp = input//".hhh"

if (! access (inp)) {
	beep
        print ""
        print ("Error: "//inp//" does not exist ! -- exiting")
        bye
}
if (access (coordout)) {
	beep
        print ""
        print ("Error: "//coordout//" already exists ! -- exiting")
        bye
}

if (dispim)
	display (inp, zs+)

qtmp1 = mktemp ("tmpq")

#
# Now get input image coords:
#
#
print ("Mark reference stars:\n")
print ("# Coordinate list for "//inp, >coordout)
fitpsf (inp, 7., func="elgauss", inter=yes, veri=no, out=qtmp1)
txdump (qtmp1, "xcen,ycen", yes, >>coordout)
delete (qtmp1, veri-, def+)
edit (coordout)

}
end
